/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot;

import com.google.gson.Gson;
import com.pengrad.telegrambot.BotUtils;
import com.pengrad.telegrambot.Callback;
import com.pengrad.telegrambot.ExceptionHandler;
import com.pengrad.telegrambot.UpdatesListener;
import com.pengrad.telegrambot.impl.FileApi;
import com.pengrad.telegrambot.impl.TelegramBotClient;
import com.pengrad.telegrambot.impl.UpdatesHandler;
import com.pengrad.telegrambot.model.File;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.request.GetUpdates;
import com.pengrad.telegrambot.response.BaseResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public class TelegramBot {
    private final TelegramBotClient api;
    private final FileApi fileApi;
    private final UpdatesHandler updatesHandler;

    public TelegramBot(String botToken) {
        this(new Builder(botToken));
    }

    TelegramBot(Builder builder) {
        this.api = builder.api;
        this.fileApi = builder.fileApi;
        this.updatesHandler = builder.updatesHandler;
    }

    public <T extends BaseRequest<T, R>, R extends BaseResponse> R execute(BaseRequest<T, R> request) {
        return this.api.send(request);
    }

    public <T extends BaseRequest<T, R>, R extends BaseResponse> void execute(T request, Callback<T, R> callback) {
        this.api.send(request, callback);
    }

    public String getFullFilePath(File file) {
        return this.fileApi.getFullFilePath(file.filePath());
    }

    public byte[] getFileContent(File file) throws IOException {
        String fileUrl = this.getFullFilePath(file);
        URLConnection connection = new URL(fileUrl).openConnection();
        try (InputStream is = connection.getInputStream();){
            byte[] byArray = BotUtils.getBytesFromInputStream(is);
            return byArray;
        }
    }

    public void setUpdatesListener(UpdatesListener listener) {
        this.setUpdatesListener(listener, new GetUpdates());
    }

    public void setUpdatesListener(UpdatesListener listener, GetUpdates request) {
        this.setUpdatesListener(listener, null, request);
    }

    public void setUpdatesListener(UpdatesListener listener, ExceptionHandler exceptionHandler) {
        this.setUpdatesListener(listener, exceptionHandler, new GetUpdates());
    }

    public void setUpdatesListener(UpdatesListener listener, ExceptionHandler exceptionHandler, GetUpdates request) {
        this.updatesHandler.start(this, listener, exceptionHandler, request);
    }

    public void removeGetUpdatesListener() {
        this.updatesHandler.stop();
    }

    public static final class Builder {
        static final String API_URL = "https://api.telegram.org/bot";
        private final String botToken;
        private FileApi fileApi;
        private TelegramBotClient api;
        private UpdatesHandler updatesHandler;
        private OkHttpClient okHttpClient;
        private String apiUrl;
        private String fileApiUrl;

        public Builder(String botToken) {
            this.botToken = botToken;
            this.api = new TelegramBotClient(Builder.client(null), Builder.gson(), Builder.apiUrl(API_URL, botToken));
            this.fileApi = new FileApi(botToken);
            this.updatesHandler = new UpdatesHandler(100L);
        }

        public Builder debug() {
            this.okHttpClient = Builder.client(Builder.httpLoggingInterceptor());
            return this;
        }

        public Builder okHttpClient(OkHttpClient client) {
            this.okHttpClient = client;
            return this;
        }

        public Builder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public Builder fileApiUrl(String fileApiUrl) {
            this.fileApiUrl = fileApiUrl;
            return this;
        }

        public Builder updateListenerSleep(long millis) {
            this.updatesHandler = new UpdatesHandler(millis);
            return this;
        }

        public TelegramBot build() {
            if (this.okHttpClient != null || this.apiUrl != null) {
                OkHttpClient client = this.okHttpClient != null ? this.okHttpClient : Builder.client(null);
                String baseUrl = Builder.apiUrl(this.apiUrl != null ? this.apiUrl : API_URL, this.botToken);
                this.api = new TelegramBotClient(client, Builder.gson(), baseUrl);
            }
            if (this.fileApiUrl != null) {
                this.fileApi = new FileApi(this.fileApiUrl, this.botToken);
            }
            return new TelegramBot(this);
        }

        private static OkHttpClient client(Interceptor interceptor) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(75L, TimeUnit.SECONDS).writeTimeout(75L, TimeUnit.SECONDS).readTimeout(75L, TimeUnit.SECONDS);
            if (interceptor != null) {
                builder.addInterceptor(interceptor);
            }
            return builder.build();
        }

        private static Interceptor httpLoggingInterceptor() {
            return new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY);
        }

        private static Gson gson() {
            return new Gson();
        }

        private static String apiUrl(String apiUrl, String botToken) {
            return apiUrl + botToken + "/";
        }
    }
}

