/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.share;

import com.viettel.common.TransUtilsLogger;
import com.viettel.common.ViettelException;
import com.viettel.service.iso.ISOException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class Util {
    public static final String ASCII = "ASCII";
    public static final String AES_METHOD = "AES";
    private static Random random = new Random();

    public static String padleft(String s, int len, char c) throws ViettelException {
        if ((s = s.trim()).length() > len) {
            throw new ViettelException("invalid len " + s.length() + "/" + len);
        }
        StringBuffer d = new StringBuffer(len);
        int fill = len - s.length();
        while (fill-- > 0) {
            d.append(c);
        }
        d.append(s);
        return d.toString();
    }

    public static String zeropad(String s, int len) throws ViettelException {
        return Util.padleft(s, len, '0');
    }

    public static String strpad(String s, int len) {
        StringBuffer d = new StringBuffer(s);
        while (d.length() < len) {
            d.append(' ');
        }
        return d.toString();
    }

    public static byte[] str2bcd(String s, boolean padLeft) {
        int start;
        int len = s.length();
        byte[] d = new byte[len + 1 >> 1];
        for (int i = start = (len & 1) == 1 && padLeft ? 1 : 0; i < len + start; ++i) {
            int n = i >> 1;
            d[n] = (byte)(d[n] | s.charAt(i - start) - 48 << ((i & 1) == 1 ? 0 : 4));
        }
        return d;
    }

    public static String bcd2str(byte[] b, int offset, int len, boolean padLeft) {
        int start;
        StringBuffer d = new StringBuffer(len);
        for (int i = start = (len & 1) == 1 && padLeft ? 1 : 0; i < len + start; ++i) {
            int shift = (i & 1) == 1 ? 0 : 4;
            d.append(b[offset + (i >> 1)] >> shift & 0xF);
        }
        return d.toString();
    }

    public static String hexString(byte[] b) {
        StringBuffer d = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            char hi = Character.forDigit(b[i] >> 4 & 0xF, 16);
            char lo = Character.forDigit(b[i] & 0xF, 16);
            d.append(Character.toUpperCase(hi));
            d.append(Character.toUpperCase(lo));
        }
        return d.toString();
    }

    public static String bitSet2String(BitSet b) {
        int len = b.size();
        StringBuffer d = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            d.append(b.get(i) ? (char)'1' : '0');
        }
        return d.toString();
    }

    public static byte[] bitSet2byte(BitSet b) {
        int len = b.size() >> 3 << 3;
        byte[] d = new byte[len >> 3];
        for (int i = 0; i < len; ++i) {
            if (!b.get(i + 1)) continue;
            int n = i >> 3;
            d[n] = (byte)(d[n] | 128 >> i % 8);
        }
        if (len > 64) {
            d[0] = (byte)(d[0] | 0x80);
        }
        return d;
    }

    public static BitSet byte2BitSet(byte[] b, int offset) {
        int len = (b[offset] & 0x80) == 128 ? 128 : 64;
        BitSet bmap = new BitSet(len);
        for (int i = 0; i < len; ++i) {
            if ((b[offset + (i >> 3)] & 128 >> i % 8) <= 0) continue;
            bmap.set(i + 1);
        }
        return bmap;
    }

    public static BitSet hex2BitSet(byte[] b, int offset) {
        int len = (Character.digit((char)b[offset], 16) & 8) == 8 ? 128 : 64;
        BitSet bmap = new BitSet(len);
        for (int i = 0; i < len; ++i) {
            int digit = Character.digit((char)b[offset + (i >> 2)], 16);
            if ((digit & 8 >> i % 4) <= 0) continue;
            bmap.set(i + 1);
        }
        return bmap;
    }

    public static byte[] hex2byte(byte[] b) {
        int len = b.length / 2;
        byte[] d = new byte[len];
        for (int i = 0; i < len * 2; ++i) {
            int shift = i % 2 == 1 ? 0 : 4;
            int n = i >> 1;
            d[n] = (byte)(d[n] | Character.digit((char)b[i], 16) << shift);
        }
        return d;
    }

    public static String formatDouble(double d, int len) {
        String prefix = Long.toString((long)d);
        String suffix = Integer.toString((int)(d * 100.0 % 100.0));
        try {
            prefix = Util.padleft(prefix, len - 3, ' ');
            suffix = Util.zeropad(suffix, 2);
        }
        catch (ViettelException e) {
            e.printStackTrace();
        }
        return prefix + "." + suffix;
    }

    public static String getMD5(String value) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(value.getBytes(), 0, value.length());
        byte[] md5hash = md.digest();
        return Util.hexString(md5hash);
    }

    public static String genChallenge() {
        return Integer.toHexString(random.nextInt());
    }

    public static String getDateString(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(date);
    }

    public static String getCurrentDateLongString() {
        return Util.getDateString(Calendar.getInstance().getTime(), "yyyyMMddHHmmss");
    }

    public static String getDateLongString(Date date) {
        return Util.getDateString(date, "yyyyMMddHHmmss");
    }

    public static String getDateShortString(Date date) {
        return Util.getDateString(date, "yyyyMMdd");
    }

    public static Date getDateFromLongString(String value) {
        return Util.getDate(value, "yyyyMMddHHmmss");
    }

    public static Date getSmartlinkDate(String value) {
        return Util.getDate(Calendar.getInstance().get(1) + value, "yyyyMMddHHmmss");
    }

    public static String getSmartlinkString(Date date) {
        return Util.getDateString(date, "MMddHHmmss");
    }

    public static Date getDateFromShortString(String value) {
        return Util.getDate(value, "yyyyMMdd");
    }

    public static Date getDate(String value, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Date result = null;
        try {
            result = sdf.parse(value);
        }
        catch (ParseException e) {
            TransUtilsLogger.warn((Object)("parse error: " + e));
        }
        return result;
    }

    public static String getCurrentDateShortString() {
        return Util.getDateString(Calendar.getInstance().getTime(), "yyyyMMdd");
    }

    public static byte[] stringToByte(String strVal) {
        byte[] bVal = new byte[strVal.length()];
        char[] chBuffer = strVal.toCharArray();
        for (int i = 0; i < strVal.length(); ++i) {
            bVal[i] = (byte)chBuffer[i];
        }
        return bVal;
    }

    public static String byteToString(byte[] bVal) {
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < bVal.length; ++i) {
            strBuffer.append((char)bVal[i]);
        }
        return strBuffer.toString();
    }

    public static String aesEncrypt(SecretKey key, String value) throws InvalidKeyException, ISOException {
        byte[] input = null;
        try {
            input = value.getBytes(ASCII);
        }
        catch (UnsupportedEncodingException e) {
            TransUtilsLogger.error((Object)"AES encrypt error", (Throwable)e);
        }
        SecretKeySpec skeySpec = new SecretKeySpec(key.getEncoded(), AES_METHOD);
        try {
            Cipher cipher = Cipher.getInstance(AES_METHOD);
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(input);
            byte[] encoded = Base64.encodeBase64((byte[])encrypted);
            return new String(encoded, ASCII);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ISOException("NoSuchAlgorithException " + e);
        }
        catch (NoSuchPaddingException e) {
            throw new ISOException("NoSuchPaddingException " + e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ISOException("IllegalBlockSizeException " + e);
        }
        catch (BadPaddingException e) {
            throw new ISOException("BadPaddingException " + e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ISOException("Encoding error: " + e);
        }
    }

    public static String base64Encode(String value) {
        String result = null;
        try {
            byte[] input = value.getBytes(ASCII);
            result = new String(Base64.encodeBase64((byte[])input), ASCII);
        }
        catch (UnsupportedEncodingException e) {
            TransUtilsLogger.warn((Object)("encode error " + e));
        }
        return result;
    }

    public static String base64Encode(byte[] value) {
        String result = null;
        try {
            result = new String(Base64.encodeBase64((byte[])value), ASCII);
        }
        catch (UnsupportedEncodingException e) {
            TransUtilsLogger.warn((Object)("encode error " + e));
        }
        return result;
    }

    public static String base64Decode(String value) throws ISOException {
        String result = null;
        try {
            result = new String(Util.base64DecodeBytes(value), ASCII);
        }
        catch (UnsupportedEncodingException e) {
            TransUtilsLogger.warn((Object)("decode error " + e));
        }
        return result;
    }

    public static byte[] base64DecodeBytes(String value) throws ISOException {
        byte[] result;
        try {
            byte[] input = value.getBytes(ASCII);
            if (!Base64.isArrayByteBase64((byte[])input)) {
                throw new ISOException("input string isn't correct base64 format");
            }
            result = Base64.decodeBase64((byte[])input);
        }
        catch (UnsupportedEncodingException e) {
            TransUtilsLogger.warn((Object)("base 64 error, return empty array: " + e));
            result = new byte[]{};
        }
        return result;
    }

    public static String aesDecrypt(SecretKey key, String value) throws InvalidKeyException, ISOException {
        byte[] input = null;
        try {
            input = value.getBytes(ASCII);
        }
        catch (UnsupportedEncodingException e) {
            TransUtilsLogger.warn((Object)("never happend?" + e));
        }
        if (!Base64.isArrayByteBase64((byte[])input)) {
            throw new ISOException("input string to aesDecrypt not valid base64 format");
        }
        byte[] planInput = Base64.decodeBase64((byte[])input);
        SecretKeySpec skeySpec = new SecretKeySpec(key.getEncoded(), AES_METHOD);
        try {
            Cipher cipher = Cipher.getInstance(AES_METHOD);
            cipher.init(2, skeySpec);
            byte[] decrypted = cipher.doFinal(planInput);
            return new String(decrypted, ASCII);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ISOException("NoSuchAlgorithException " + e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new ISOException("NoSuchPaddingException " + e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new ISOException("Data to decrypt is invalid? IllegalBlockSizeException " + e.getMessage());
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
            throw new ISOException("Data to decrypt is invalid? " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new ISOException("Data to decrypt is invalid? " + e.getMessage());
        }
    }

    public static SecretKey createSecretKey(String raw) {
        return new SecretKeySpec(Util.hex2byte(raw.getBytes()), AES_METHOD);
    }

    public static String generateSecretKey() throws NoSuchAlgorithmException {
        KeyGenerator kgen = KeyGenerator.getInstance(AES_METHOD);
        kgen.init(128);
        SecretKey skey = kgen.generateKey();
        byte[] raw = skey.getEncoded();
        return Util.hexString(raw);
    }

    public static String smax(String value, int maxsize) {
        if (value.length() > maxsize) {
            return value.substring(0, maxsize - 6) + " [...]";
        }
        return value;
    }

    public static long getFreeSpace(String path) {
        if (path == null) {
            throw new NullPointerException("path cannot be null");
        }
        File file = new File(path);
        if (!file.exists()) {
            return -1L;
        }
        return file.getUsableSpace();
    }

    private static void printThreadInfo(Thread t, String indent) {
        if (t == null) {
            return;
        }
        System.out.println(indent + "Thread: " + t.getName() + "  Priority: " + t.getPriority() + (t.isDaemon() ? " Daemon" : " Not Daemon") + (t.isAlive() ? "" : " Not Alive"));
    }

    private static void printGroupInfo(ThreadGroup g, String indent) {
        int i;
        if (g == null) {
            return;
        }
        int numThreads = g.activeCount();
        int numGroups = g.activeGroupCount();
        Thread[] threads = new Thread[numThreads];
        ThreadGroup[] groups = new ThreadGroup[numGroups];
        g.enumerate(threads, false);
        g.enumerate(groups, false);
        System.out.println(indent + "Thread Group: " + g.getName() + "  Max Priority: " + g.getMaxPriority() + (g.isDaemon() ? " Daemon" : ""));
        for (i = 0; i < numThreads; ++i) {
            Util.printThreadInfo(threads[i], indent + "    ");
        }
        for (i = 0; i < numGroups; ++i) {
            Util.printGroupInfo(groups[i], indent + "    ");
        }
    }

    public static void listAllThreads() {
        ThreadGroup currentThreadGroup;
        ThreadGroup rootThreadGroup = currentThreadGroup = Thread.currentThread().getThreadGroup();
        for (ThreadGroup parent = rootThreadGroup.getParent(); parent != null; parent = parent.getParent()) {
            rootThreadGroup = parent;
        }
        Util.printGroupInfo(rootThreadGroup, "");
    }
}

