/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.security;

import com.viettel.security.CryptoDevice;
import com.viettel.utils.security.util.ByteUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class Crypto3DES
implements CryptoDevice {
    protected String fullAlgorithm = "DESede/CBC/NoPadding";
    protected String algorithm = "DESede";
    protected byte padByte;
    protected int bufLen = 1024;
    protected boolean debugOutput = false;
    protected byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    public Crypto3DES() {
        this.padByte = (byte)-1;
    }

    public Crypto3DES(String algorithm) {
        this.padByte = (byte)-1;
        this.setAlgorithm(algorithm);
    }

    public Crypto3DES(byte padByte) {
        this.padByte = (byte)-1;
        this.setPadByte(padByte);
    }

    public Crypto3DES(byte[] iv) {
        this.padByte = (byte)-1;
        this.setIV(iv);
    }

    public Crypto3DES(String algorithm, byte padByte) {
        this.padByte = (byte)-1;
        this.setAlgorithm(algorithm);
        this.setPadByte(padByte);
    }

    public Crypto3DES(String algorithm, byte[] iv) {
        this.padByte = (byte)-1;
        this.setAlgorithm(algorithm);
        this.setIV(iv);
    }

    public Crypto3DES(String algorithm, byte padByte, byte[] iv) {
        this.padByte = (byte)-1;
        this.setAlgorithm(algorithm);
        this.setPadByte(padByte);
        this.setIV(iv);
    }

    public void open() throws IOException {
    }

    public void close() {
    }

    public void setAlgorithm(String algorithm) {
        if (algorithm != null) {
            this.fullAlgorithm = algorithm;
            StringTokenizer st = new StringTokenizer(algorithm, "/");
            this.algorithm = st.nextToken();
        }
    }

    public String getAlgorithm() {
        return this.fullAlgorithm;
    }

    public void setPadByte(byte padByte) {
        this.padByte = padByte;
    }

    public byte getPadByte() {
        return this.padByte;
    }

    public void setIV(String iv) {
        if (iv != null) {
            this.setIV(ByteUtils.stringToBytes(iv));
        }
    }

    public void setIV(byte[] iv) {
        int bs = 8;
        try {
            Cipher cipher = Cipher.getInstance(this.fullAlgorithm);
            bs = cipher.getBlockSize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.iv = new byte[bs];
        if (iv != null) {
            iv = this.rightPad(iv, (byte)0, bs);
            System.arraycopy(iv, 0, this.iv, 0, bs);
        }
    }

    public byte[] getIV() {
        return this.iv;
    }

    public void setBufferLength(int bufLen) {
        if (bufLen > 0) {
            this.bufLen = bufLen;
        }
    }

    public int getBufferLength() {
        return this.bufLen;
    }

    public void setDebugOutput(boolean state) {
        this.debugOutput = state;
    }

    public boolean getDebugOutput() {
        return this.debugOutput;
    }

    public String encrypt(String data, String encryptKey) {
        try {
            byte[] key = this.stringTo3DESKey(encryptKey);
            byte[] input = ByteUtils.asciiStringToBytes(data);
            byte[] b = this.encrypt(input, key);
            data = ByteUtils.bytesToASCIIString(b);
        }
        catch (Exception e) {
            data = null;
        }
        return data;
    }

    public byte[] encrypt(byte[] data, byte[] key) {
        try {
            int bs;
            int len;
            Cipher cipher = Cipher.getInstance(this.fullAlgorithm);
            cipher.init(1, (Key)SecretKeyFactory.getInstance(this.algorithm).generateSecret(new DESedeKeySpec(key)), new IvParameterSpec(this.getIV()));
            if (this.fullAlgorithm.toLowerCase().indexOf("nopadding") != -1 && (len = data.length) % (bs = cipher.getBlockSize()) != 0) {
                len = data.length + (bs - data.length % bs);
                data = this.rightPad(data, this.padByte, len);
            }
            data = this.doCipher(data, cipher);
        }
        catch (Exception e) {
            data = null;
        }
        return data;
    }

    public String decrypt(String data, String decryptKey) {
        try {
            byte[] key = this.stringTo3DESKey(decryptKey);
            byte[] input = ByteUtils.asciiStringToBytes(data);
            byte[] b = this.decrypt(input, key);
            data = ByteUtils.bytesToASCIIString(b);
        }
        catch (Exception e) {
            data = null;
        }
        return data;
    }

    public byte[] decrypt(byte[] data, byte[] key) {
        try {
            byte[] txfr;
            Cipher cipher = Cipher.getInstance(this.fullAlgorithm);
            cipher.init(2, (Key)SecretKeyFactory.getInstance(this.algorithm).generateSecret(new DESedeKeySpec(key)), new IvParameterSpec(this.getIV()));
            int numPadBytes = -1;
            if (data.length % cipher.getBlockSize() == 1) {
                numPadBytes = data[0] & 7;
                txfr = new byte[data.length - 1];
                System.arraycopy(data, 1, txfr, 0, data.length - 1);
                data = txfr;
            }
            data = this.doCipher(data, cipher);
            if (numPadBytes != -1) {
                txfr = new byte[data.length - numPadBytes];
                System.arraycopy(data, 0, txfr, 0, txfr.length);
                data = txfr;
            } else if (this.fullAlgorithm.toLowerCase().indexOf("nopadding") != -1) {
                data = this.rightStrip(data, this.padByte);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            data = null;
        }
        return data;
    }

    public String reencrypt(String data, String decryptKey, String encryptKey) {
        data = this.decrypt(data, decryptKey);
        return this.encrypt(data, encryptKey);
    }

    public byte[] reencrypt(byte[] data, byte[] decryptKey, byte[] encryptKey) {
        data = this.decrypt(data, decryptKey);
        return this.encrypt(data, encryptKey);
    }

    public String transformKey(String originalKey, String domainKey) {
        return originalKey;
    }

    public byte[] stringTo3DESKey(String key) throws IllegalArgumentException {
        byte[] b = new byte[24];
        if (key.length() == 16) {
            ByteUtils.stringToBytes(key, b);
            for (int i = 0; i < 8; ++i) {
                b[i + 8] = b[i];
                b[i + 16] = b[i];
            }
        } else if (key.length() == 32) {
            ByteUtils.stringToBytes(key, b);
            for (int i = 0; i < 8; ++i) {
                b[i + 16] = b[i];
            }
        } else if (key.length() == 48) {
            ByteUtils.stringToBytes(key, b);
        } else {
            throw new IllegalArgumentException("invalid key");
        }
        b = ByteUtils.ensureDESParity(b);
        return b;
    }

    protected byte[] doCipher(byte[] data, Cipher cipher) throws IOException, IllegalBlockSizeException, BadPaddingException {
        int bytesRead;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[this.bufLen];
        while ((bytesRead = bis.read(buffer)) != -1) {
            bos.write(cipher.update(buffer, 0, bytesRead));
        }
        bos.write(cipher.doFinal());
        return bos.toByteArray();
    }

    protected byte[] rightPad(byte[] data, byte padByte, int padWidth) {
        int len = data.length;
        if (len < padWidth) {
            byte[] nb = new byte[padWidth];
            System.arraycopy(data, 0, nb, 0, len);
            for (int i = len; i < padWidth; ++i) {
                nb[i] = padByte;
            }
            data = nb;
        }
        return data;
    }

    protected byte[] rightStrip(byte[] data, byte padByte) {
        int pos = data.length;
        while (data[pos - 1] == padByte) {
            --pos;
        }
        if (pos != data.length) {
            byte[] nb = new byte[pos];
            System.arraycopy(data, 0, nb, 0, pos);
            data = nb;
        }
        return data;
    }

    public String toString() {
        return "Crypto3DES";
    }
}

