/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.warnning;

import com.viettel.mmserver.agent.MMbeanServer;
import com.viettel.mmserver.agent.MmJMXServerSec;
import com.viettel.mmserver.base.ConfigParam;
import com.viettel.mmserver.base.Log;
import com.viettel.mmserver.base.ProcessThreadMX;
import com.viettel.mmserver.database.DatabaseAccessor;
import com.viettel.mmserver.warnning.TimeoutInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class BlockedThreadDetector
extends ProcessThreadMX
implements NotificationListener {
    public static final int DEFAULTFOOLINGMINUTE = 5;
    public static final int DEFAULTIMEOUTMINUTE = 5;
    public static final int MINUTE20 = 20;
    public static final String OBJECT_NAME = "Tools:name=BlockedDetector";
    private static BlockedThreadDetector instance = null;
    private ArrayList<ObjectName> threadList = new ArrayList();
    private ArrayList<ObjectName> blockedThreadList = new ArrayList();
    private ArrayList<String> blockedSMS = new ArrayList();
    private String applicationId = "";
    private HashMap<String, TimeoutInfo> threadTimeout = null;
    private static final long MILISECONDOFMINUTE = 60000L;
    private long defaultTimeout = 300000L;
    private long defaultPoolingPeriod = 300000L;
    private boolean sendUnblockedSMS = false;
    private boolean defaultSendSMS = false;
    private final Object threadListLock = new Object();
    private final Object threadTimeoutLock = new Object();
    private static final String BLOCKEDNOTIFYTYPE = "process.blocked";
    private long smsThreshold = 1200000L;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss dd/MM/yyyy");
    private Date lastSend = null;

    private BlockedThreadDetector() {
        super("Blocked Detecting Thread", " A thread of mmserver that detects blocked thread");
        String strSendSMS;
        String strSendUnblockedSMS;
        String strDefaultPooling;
        String strDefaultTimeout;
        try {
            this.registerAgent(OBJECT_NAME);
        }
        catch (MalformedObjectNameException ex) {
            Log.info(ex);
        }
        catch (InstanceAlreadyExistsException ex) {
            Log.info(ex);
        }
        catch (MBeanRegistrationException ex) {
            Log.info(ex);
        }
        catch (NotCompliantMBeanException ex) {
            Log.info(ex);
        }
        ObjectName mbeanServerDelegate = null;
        try {
            mbeanServerDelegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException ex) {
            Log.info("Can not find MbeanServerDelegate: " + ex);
        }
        catch (NullPointerException ex) {
            Log.info("Can not find MbeanServerDelegate: " + ex);
        }
        try {
            if (mbeanServerDelegate != null) {
                MMbeanServer.getInstance().addNotificationListener(mbeanServerDelegate, this, null, null);
            }
        }
        catch (InstanceNotFoundException ex) {
            Log.info("Can not registry listener to MbeanServerDelegate: " + ex);
        }
        this.applicationId = System.getProperty("com.viettel.mmserver.appid", "");
        if (this.applicationId != null && !this.applicationId.equals("")) {
            this.threadTimeout = DatabaseAccessor.shareInstance().selectThreadTimeout(this.applicationId);
        }
        if ((strDefaultTimeout = System.getProperty("com.viettel.mmserver.blockedDetect.defaultTimeout")) != null) {
            long iTimeout = this.defaultTimeout;
            try {
                this.defaultTimeout = iTimeout = (long)Integer.valueOf(strDefaultTimeout).intValue() * 60000L;
            }
            catch (NumberFormatException e) {
                Log.error("Can not read default timeout");
            }
        }
        if ((strDefaultPooling = System.getProperty("com.viettel.mmserver.blockedDetect.defaultPoolingPeriod")) != null) {
            long ipooling = this.defaultPoolingPeriod;
            try {
                this.defaultPoolingPeriod = ipooling = (long)Integer.valueOf(strDefaultPooling).intValue() * 60000L;
            }
            catch (NumberFormatException e) {
                Log.error("Can not read default pooling period");
            }
        }
        if ((strSendUnblockedSMS = System.getProperty("com.viettel.mmserver.blockedDetect.unblockedSMS")) != null && strSendUnblockedSMS.equals("1")) {
            this.sendUnblockedSMS = true;
        }
        if ((strSendSMS = System.getProperty("com.viettel.mmserver.blockedDetect.defaultBlockedSMS")) != null && strSendSMS.equals("1")) {
            this.defaultSendSMS = true;
        }
    }

    public static synchronized BlockedThreadDetector getInstance() {
        if (instance == null) {
            instance = new BlockedThreadDetector();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (!(notification instanceof MBeanServerNotification)) {
            return;
        }
        MBeanServerNotification mbsn = (MBeanServerNotification)notification;
        ObjectName mbean = mbsn.getMBeanName();
        if (notification.getType().equals("JMX.mbean.registered")) {
            if (this.pingable(mbean)) {
                Object object = this.threadListLock;
                synchronized (object) {
                    this.threadList.add(mbean);
                }
            }
        } else if (notification.getType().equals("JMX.mbean.unregistered")) {
            Object object = this.threadListLock;
            synchronized (object) {
                this.threadList.remove(mbean);
            }
        }
    }

    private boolean pingable(ObjectName mbean) {
        try {
            MBeanAttributeInfo[] atts;
            for (MBeanAttributeInfo att : atts = MMbeanServer.getInstance().getMBeanInfo(mbean).getAttributes()) {
                if (!att.getName().equals("pingable")) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process() {
        try {
            Object object = this.threadListLock;
            synchronized (object) {
                long itimeout = this.defaultTimeout;
                boolean sendSMS = this.defaultSendSMS;
                TimeoutInfo timeoutInfo = null;
                for (ObjectName thread : this.threadList) {
                    itimeout = this.defaultTimeout;
                    sendSMS = this.defaultSendSMS;
                    Long difTime = 0L;
                    try {
                        Notification notification;
                        difTime = (Long)MMbeanServer.getInstance().invoke(thread, "ping", null, null);
                        Object object2 = this.threadTimeoutLock;
                        synchronized (object2) {
                            if (this.threadTimeout != null && this.threadTimeout.containsKey(thread.toString())) {
                                timeoutInfo = this.threadTimeout.get(thread.toString());
                                itimeout = (long)timeoutInfo.getTimeout() * 60000L;
                                sendSMS = timeoutInfo.isSendSMS();
                            }
                        }
                        if (difTime > itimeout) {
                            if (!this.blockedThreadList.contains(thread)) {
                                this.blockedThreadList.add(thread);
                            }
                            notification = new Notification(BLOCKEDNOTIFYTYPE, (Object)thread.toString(), 0L, "1");
                            this.notificationHandler.sendNotification(notification);
                            if (!sendSMS) continue;
                            this.filterNotification(thread.toString());
                            continue;
                        }
                        if (!this.blockedThreadList.contains(thread)) continue;
                        this.blockedThreadList.remove(thread);
                        notification = new Notification(BLOCKEDNOTIFYTYPE, (Object)thread.toString(), 0L, "0");
                        this.notificationHandler.sendNotification(notification);
                        if (!this.sendUnblockedSMS || !sendSMS || !this.blockedSMS.contains(thread.toString())) continue;
                        Date now = new Date();
                        String sms = "";
                        if (ConfigParam.getInstance().getDepartment() != null && !ConfigParam.getInstance().getDepartment().trim().isEmpty()) {
                            sms = "W" + ConfigParam.getInstance().getDepartment().trim() + "_";
                        }
                        sms = sms + this.applicationId + ": Tien trinh " + thread.toString() + " da het block khi check luc " + this.dateFormat.format(now) + " (" + MmJMXServerSec.getIp() + ":" + MmJMXServerSec.getPort() + ")";
                        this.logger.info((Object)sms);
                        DatabaseAccessor.shareInstance().requestSendSMS(sms, this.applicationId);
                        this.blockedSMS.remove(thread.toString());
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e);
                    }
                }
            }
            Thread.sleep(this.defaultPoolingPeriod);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertThreadTimeout(String mbean, int timeout, boolean sendSMS) {
        if (this.applicationId.equals("")) {
            return -1;
        }
        int result = DatabaseAccessor.shareInstance().insertThreadTimeout(this.applicationId, mbean, timeout, sendSMS);
        if (result > 0) {
            Object object = this.threadListLock;
            synchronized (object) {
                this.threadTimeout.put(mbean, new TimeoutInfo(timeout, sendSMS));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteThreadTimeout(String mbean) {
        if (this.applicationId.equals("")) {
            return -1;
        }
        int result = DatabaseAccessor.shareInstance().deleteThreadTimeout(this.applicationId, mbean);
        if (result > 0) {
            Object object = this.threadListLock;
            synchronized (object) {
                this.threadTimeout.remove(mbean);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int editThreadTimeout(String mbean, int timeout, boolean sendSMS) {
        if (this.applicationId.equals("")) {
            return -1;
        }
        TimeoutInfo old = this.threadTimeout.get(mbean);
        if (old == null) {
            return -1;
        }
        if (old.getTimeout() == timeout && old.isSendSMS() == sendSMS) {
            return 1;
        }
        int result = DatabaseAccessor.shareInstance().editThreadTimeout(this.applicationId, mbean, timeout, sendSMS);
        if (result > 0) {
            Object object = this.threadListLock;
            synchronized (object) {
                this.threadTimeout.put(mbean, new TimeoutInfo(timeout, sendSMS));
            }
        }
        return result;
    }

    private boolean setDefaultTimeout(int defaultTimeoutInMinutes) {
        if (defaultTimeoutInMinutes < 1) {
            return false;
        }
        this.defaultTimeout = (long)defaultTimeoutInMinutes * 60000L;
        return true;
    }

    private boolean setPoolingPeriod(int poolingPeriodInMinutes) {
        if (poolingPeriodInMinutes < 1) {
            return false;
        }
        this.defaultPoolingPeriod = (long)poolingPeriodInMinutes * 60000L;
        return true;
    }

    @Override
    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        if (operationName.equals("start")) {
            this.start();
            return null;
        }
        if (operationName.equals("stop")) {
            this.stop();
            return null;
        }
        if (operationName.equals("restart")) {
            this.restart();
            return null;
        }
        if (operationName.equals("readConfig")) {
            return this.readConfig();
        }
        if (operationName.equals("addChild")) {
            this.addChild((String)params[0], (String)params[1], (String)params[2], (String)params[3], (String)params[4]);
            return null;
        }
        if (operationName.equals("getInfor")) {
            return this.getInfor();
        }
        if (operationName.equals("ping")) {
            return this.ping();
        }
        if (operationName.equals("loadParams")) {
            return this.loadParams();
        }
        if (operationName.equals("saveParams")) {
            String newConfig = (String)params[0];
            return this.saveParams(newConfig);
        }
        if (operationName.equals("setDump")) {
            Boolean b = (Boolean)params[0];
            this.setDumpThread(b);
            return null;
        }
        if (operationName.equals("loadLoggerName")) {
            return this.loadLoggerName();
        }
        if (operationName.equals("insertThreadTimeout")) {
            String mbean = (String)params[0];
            int timeout = (Integer)params[1];
            boolean sendSMS = (Boolean)params[2];
            return this.insertThreadTimeout(mbean, timeout, sendSMS);
        }
        if (operationName.equals("editThreadTimeout")) {
            String mbean = (String)params[0];
            int timeout = (Integer)params[1];
            boolean sendSMS = (Boolean)params[2];
            return this.editThreadTimeout(mbean, timeout, sendSMS);
        }
        if (operationName.equals("deleteThreadTimeout")) {
            String mbean = (String)params[0];
            return this.deleteThreadTimeout(mbean);
        }
        if (operationName.equals("setDefaultTimeout")) {
            Integer defaultTimeoutTmp = (Integer)params[0];
            return this.setDefaultTimeout(defaultTimeoutTmp);
        }
        if (operationName.equals("setPoolingPeriod")) {
            Integer pooling = (Integer)params[0];
            return this.setPoolingPeriod(pooling);
        }
        if (operationName.equals("reloadDatabase")) {
            return this.reloadDatabase();
        }
        if (operationName.equals("setTimeBetweenTwoSMS")) {
            Integer time = (Integer)params[0];
            return this.setTimeBetweenTwoSMS(time);
        }
        throw new ReflectionException(new NoSuchMethodException(operationName), "Cannot find the operation " + operationName + " in " + this.dClassName);
    }

    @Override
    protected MBeanOperationInfo[] buildOperations() {
        ArrayList<MBeanOperationInfo> v = new ArrayList<MBeanOperationInfo>();
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        v.add(new MBeanOperationInfo("start", "start service", params, "void", 1));
        v.add(new MBeanOperationInfo("stop", "stop service", params, "void", 1));
        v.add(new MBeanOperationInfo("restart", "stop service", params, "void", 1));
        v.add(new MBeanOperationInfo("getInfor", "get configuration information and runtime state of this service", params, "java.lang.String", 1));
        v.add(new MBeanOperationInfo("ping", "get the period between the time ping() called and the lastest transation start time", params, "java.lang.Long", 1));
        v.add(new MBeanOperationInfo("loadLoggerName", "get logger name of services", params, "java.lang.String", 1));
        v.add(new MBeanOperationInfo("readConfig", "get Document represent the config file for create new child Thread", params, "org.w3c.dom.Document", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("childName", "java.lang.String", "Child's name that in form of key=value"), new MBeanParameterInfo("className", "java.lang.String", "An extend class of ProcessThreadMX class that is used to create an instance"), new MBeanParameterInfo("constructParam", "java.lang.String", "The String that is used to provide parammeters for constructing new instance of className"), new MBeanParameterInfo("variable", "java.lang.String", "variable assigned to new instance"), new MBeanParameterInfo("followingThread", "java.lang.String", "Name of thread that run following this child")};
        v.add(new MBeanOperationInfo("addChild", "create a ProcessThreadMX thread that is assigned to be a child of this thread", params, "void", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("dump", "java.lang.Boolean", "boolean value indicate track thread or not")};
        v.add(new MBeanOperationInfo("setDump", "set dumping status of current thread", params, "void", 1));
        params = new MBeanParameterInfo[]{};
        v.add(new MBeanOperationInfo("loadParams", "load params", params, "java.lang.String", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("newConfig", "java.lang.String", "The String express new config")};
        v.add(new MBeanOperationInfo("saveParams", "save params", params, "java.lang.String", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("mbean", "java.lang.String", "mbean's object name"), new MBeanParameterInfo("timeout_inMinutes", "java.lang.Integer", "thread timeout"), new MBeanParameterInfo("sendSMS", "java.lang.Boolean", "sendSMS")};
        v.add(new MBeanOperationInfo("insertThreadTimeout", "insert thread timeout", params, "java.lang.Integer", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("mbean", "java.lang.String", "mbean's object name"), new MBeanParameterInfo("timeout_inMinutes", "java.lang.Integer", "thread timeout"), new MBeanParameterInfo("sendSMS", "java.lang.Boolean", "sendSMS")};
        v.add(new MBeanOperationInfo("editThreadTimeout", "edit thread timeout", params, "java.lang.Integer", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("mbean", "java.lang.String", "mbean's object name")};
        v.add(new MBeanOperationInfo("deleteThreadTimeout", "delete thread timeout", params, "java.lang.Integer", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("defaultTimeout", "java.lang.Integer", "default timeout (in minutes)")};
        v.add(new MBeanOperationInfo("setDefaultTimeout", "set deafult tiemout", params, "void", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("defaultPoolingPeriod", "java.lang.Integer", "default pooling Period (in minutes)")};
        v.add(new MBeanOperationInfo("setPoolingPeriod", "set pooling period", params, "void", 1));
        params = new MBeanParameterInfo[]{};
        v.add(new MBeanOperationInfo("reloadDatabase", "reload timeout infos from database", params, "boolean", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("time_between_two_SMS", "java.lang.Integer", "time between two SMS (in minutes)")};
        v.add(new MBeanOperationInfo("setTimeBetweenTwoSMS", "set time between two SMS", params, "boolean", 1));
        return v.toArray(new MBeanOperationInfo[v.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reloadDatabase() {
        if (this.applicationId != null && !this.applicationId.equals("")) {
            HashMap<String, TimeoutInfo> temp = null;
            temp = DatabaseAccessor.shareInstance().selectThreadTimeout(this.applicationId);
            if (temp != null) {
                Object object = this.threadTimeoutLock;
                synchronized (object) {
                    this.threadTimeout = temp;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfor() {
        StringBuilder str = new StringBuilder(super.getInfor());
        str.append(System.getProperty("line.separator"));
        str.append("Recent blocked thread: ");
        str.append(System.getProperty("line.separator"));
        for (ObjectName thread : this.blockedThreadList) {
            str.append("\t");
            str.append(thread.toString());
            str.append(System.getProperty("line.separator"));
        }
        str.append("Time between two SMS: ");
        str.append(this.smsThreshold / 60000L);
        str.append(" minutes");
        str.append(System.getProperty("line.separator"));
        str.append("Pooling period: ");
        str.append(this.defaultPoolingPeriod);
        str.append(" miliseconds");
        str.append(System.getProperty("line.separator"));
        str.append("Default timeout: ");
        str.append(this.defaultTimeout);
        str.append(" miliseconds");
        str.append(System.getProperty("line.separator"));
        str.append("Timeout infos: \tthread'name - timeout(minutes) - sendSMS");
        str.append(System.getProperty("line.separator"));
        Object object = this.threadTimeoutLock;
        synchronized (object) {
            Set<Map.Entry<String, TimeoutInfo>> s = this.threadTimeout.entrySet();
            for (Map.Entry<String, TimeoutInfo> entry : s) {
                str.append("\t");
                str.append(entry.getKey());
                str.append(" - ");
                str.append(entry.getValue().getTimeout());
                str.append(" - ");
                str.append(entry.getValue().isSendSMS() ? "Yes" : "No");
                str.append(System.getProperty("line.separator"));
            }
        }
        return str.toString();
    }

    private void filterNotification(String threadName) {
        Date now = new Date();
        String sms = "";
        if (ConfigParam.getInstance().getDepartment() != null && !ConfigParam.getInstance().getDepartment().trim().isEmpty()) {
            sms = "W" + ConfigParam.getInstance().getDepartment().trim() + "_";
        }
        sms = sms + this.applicationId + ": Tien trinh " + threadName + " bi block luc " + this.dateFormat.format(now) + " (" + MmJMXServerSec.getIp() + ":" + MmJMXServerSec.getPort() + ")";
        this.logger.info((Object)sms);
        if (this.lastSend == null || now.getTime() - this.lastSend.getTime() > this.smsThreshold) {
            DatabaseAccessor.shareInstance().requestSendSMS(sms, this.applicationId);
            this.lastSend = now;
            if (!this.blockedSMS.contains(threadName)) {
                this.blockedSMS.add(threadName);
            }
        }
    }

    private boolean setTimeBetweenTwoSMS(Integer time) {
        if (time >= 1) {
            this.smsThreshold = (long)time.intValue() * 60000L;
            return true;
        }
        return false;
    }
}

