/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.log.appender;

import com.viettel.mmserver.log.appender.AppenderThreadMX;
import com.viettel.mmserver.log.appender.RegisterHostId;
import com.viettel.mmserver.log.appender.SocketWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.spi.LoggingEvent;

public class SocketWriterManager
extends AppenderThreadMX {
    public static final int SLEEP_TIME = 1000;
    private List<LoggingEvent> offlineLogQueue = new LinkedList<LoggingEvent>();
    private List<LoggingEvent> logQueue = new LinkedList<LoggingEvent>();
    private final Object offlineQueueLock = new Object();
    private final Object queueLock = new Object();
    private int maxQueue = 1000;
    private int offlineMaxQueue = 100;
    private int maxConnection = 100;
    private boolean locationInfo = false;
    private int currentId = 0;
    private final Map<Integer, SocketWriter> swMap = Collections.synchronizedMap(new HashMap());
    private static SocketWriterManager swm;

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public int getMaxQueue() {
        return this.maxQueue;
    }

    public int getOfflineMaxQueue() {
        return this.offlineMaxQueue;
    }

    public void setOfflineMaxQueue(int offlineMaxQueue) {
        this.offlineMaxQueue = offlineMaxQueue;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public void setMaxQueue(int maxQueue) {
        this.maxQueue = maxQueue;
    }

    public void setLocationInfo(boolean ilocationInfo) {
        this.locationInfo = ilocationInfo;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public List<LoggingEvent> getLogQueue() {
        return this.logQueue;
    }

    public List<LoggingEvent> getOfflineLogQueue() {
        return this.offlineLogQueue;
    }

    public Object getOfflineQueueLock() {
        return this.offlineQueueLock;
    }

    public Object getQueueLock() {
        return this.queueLock;
    }

    public static synchronized SocketWriterManager getInstance() {
        if (swm == null) {
            swm = new SocketWriterManager();
        }
        return swm;
    }

    private SocketWriterManager() {
        super("SocketWriterManager");
        try {
            super.registerAgent("Tools:type=log,name=SocketWriterManager");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process() {
        LoggingEvent event = null;
        Map<Integer, SocketWriter> map = this.queueLock;
        synchronized (map) {
            if (this.logQueue.size() > 0) {
                event = this.logQueue.remove(0);
            }
        }
        if (event != null && this.swMap.size() > 0) {
            if (this.locationInfo) {
                event.getLocationInformation();
            }
            map = this.swMap;
            synchronized (map) {
                for (SocketWriter sw : this.swMap.values()) {
                    sw.addToQueue(event);
                }
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfor() {
        int queueSize = 0;
        Object object = this.queueLock;
        synchronized (object) {
            queueSize = this.logQueue.size();
        }
        String info = "";
        info = "MaxQueue: " + this.maxQueue + ", currentQueueSize: " + queueSize;
        info = info + "\nOfflineMaxQueue: " + this.offlineMaxQueue;
        info = info + "\nMaxConnection: " + this.maxConnection + ", the number of connection: " + this.swMap.size();
        Map<Integer, SocketWriter> map = this.swMap;
        synchronized (map) {
            for (SocketWriter sw : this.swMap.values()) {
                info = info + "\n" + sw.getThreadName();
                info = info + "\n" + sw.getInfor();
            }
        }
        return super.getInfor() + "\n" + info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSocketWriter(Socket socket) {
        block11: {
            ObjectOutputStream oos = null;
            if (socket != null) {
                int xxx = RegisterHostId.getInstance().containHost(socket.getRemoteSocketAddress().toString());
                System.out.println("=============================" + xxx + socket.getRemoteSocketAddress().toString());
                try {
                    if (xxx != -1) {
                        oos = new ObjectOutputStream(socket.getOutputStream());
                        if (this.swMap.size() < this.maxConnection) {
                            InetAddress remoteAddress = socket.getInetAddress();
                            String clientDescription = remoteAddress.getHostName() + " (" + remoteAddress.getHostAddress() + ")";
                            SocketWriter sw = new SocketWriter(oos, this.maxQueue, this.currentId, clientDescription);
                            if (sw == null) break block11;
                            Object object = this.offlineQueueLock;
                            synchronized (object) {
                                sw.flushOfflineQueue(this.offlineLogQueue);
                            }
                            this.swMap.put(new Integer(this.currentId), sw);
                            sw.setSwm(swm);
                            sw.start();
                            ++this.currentId;
                            break block11;
                        }
                        socket.close();
                        break block11;
                    }
                    socket.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void removeSocketWriter(int id) {
        SocketWriter sw;
        if (id >= 0 && (sw = this.swMap.get(new Integer(id))) != null) {
            this.swMap.remove(new Integer(id));
        }
    }
}

