/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.base;

import com.viettel.mmserver.base.ProcessThreadMX;
import com.viettel.mmserver.scheduler.DailyTask;
import com.viettel.mmserver.scheduler.Scheduler;
import com.viettel.mmserver.scheduler.Task;
import java.util.ArrayList;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public abstract class CustomizedProcessThreadMX
extends ProcessThreadMX {
    Thread processorThread = null;

    public CustomizedProcessThreadMX(String threadName) {
        super(threadName);
    }

    public CustomizedProcessThreadMX(String threadName, String description) {
        super(threadName, description);
    }

    @Override
    protected MBeanOperationInfo[] buildOperations() {
        MBeanOperationInfo[] mbInfors = super.buildOperations();
        MBeanOperationInfo[] mbNewInfors = new MBeanOperationInfo[mbInfors.length + 2];
        System.arraycopy(mbInfors, 0, mbNewInfors, 0, mbInfors.length);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        mbNewInfors[mbInfors.length] = new MBeanOperationInfo("oneTimeProcess", "process one time", params, "void", 1);
        params = new MBeanParameterInfo[]{};
        mbNewInfors[mbInfors.length + 1] = new MBeanOperationInfo("stopOneTimeProcess", "stop one time process", params, "void", 1);
        return mbNewInfors;
    }

    @Override
    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        if (operationName.equals("oneTimeProcess")) {
            this.processOneTime();
            return null;
        }
        if (operationName.equals("stopOneTimeProcess")) {
            this.stopOneTimeProcess();
            return null;
        }
        return super.invoke(operationName, params, signature);
    }

    private void processOneTime() {
        if (!this.running) {
            this.running = true;
            this.logger.info((Object)("starting " + this.threadName + " process..."));
            this.processorThread = new Thread(new OneTimeProcess());
            this.processorThread.setPriority(this.priority);
            this.processorThread.setName(this.threadName);
            this.processorThread.start();
            this.setProcessStatus(0);
            this.logger.info((Object)(this.threadName + " process  is started"));
        } else {
            this.logger.info((Object)(this.threadName + " process  is started"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopOneTimeProcess() {
        if (this.running) {
            this.setProcessStatus(2);
            this.prepareStop();
            this.logger.info((Object)("stop " + this.threadName + " process"));
            this.running = false;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            if (this.processorThread != null) {
                this.processorThread.interrupt();
            }
            try {
                if (this.processorThread != null && this.processorThread.isAlive()) {
                    this.logger.info((Object)("waiting " + this.threadName + " process stop..."));
                    this.processorThread.join();
                }
            }
            catch (InterruptedException ex) {
                this.logger.error((Object)("stop process exception:" + ex));
            }
            finally {
                this.logger.info((Object)(this.threadName + " process is stopped"));
            }
            this.setProcessStatus(1);
        }
    }

    @Override
    public void start() {
        if (this.checkCoLich()) {
            return;
        }
        super.start();
    }

    public boolean checkCoLich() {
        ArrayList taskList = (ArrayList)Scheduler.getInstance("Scheduler").getTaskList();
        for (Task task : taskList) {
            task.getStrMethodName().equals("start");
            if (!task.getStrObjectName().equals(this.objectName)) continue;
            if (task.getTaskType().equals((Object)Scheduler.TaskType.DAILY) && task.getIntStatus() == 1) {
                DailyTask dailyTask = (DailyTask)task;
                dailyTask.getStartDate();
                dailyTask.getStartTime();
                dailyTask.getEndDate();
                dailyTask.getRepeatedTask().getRepeatedRecurrencePeriod();
            }
            return true;
        }
        return false;
    }

    private class OneTimeProcess
    implements Runnable {
        private OneTimeProcess() {
        }

        @Override
        public void run() {
            CustomizedProcessThreadMX.this.setProcessStatus(0);
            try {
                CustomizedProcessThreadMX.this.process();
                Thread.yield();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                CustomizedProcessThreadMX.this.logger.error((Object)("catch runtime exception[" + ex.toString() + "]"));
            }
            CustomizedProcessThreadMX.this.logger.info((Object)(CustomizedProcessThreadMX.this.threadName + " is dead"));
            CustomizedProcessThreadMX.this.setProcessStatus(1);
        }
    }
}

