/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.authenticator;

import com.viettel.mmserver.agent.MmJMXServerSec;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MmUser
implements Serializable {
    private final String username;
    private final String password;
    private final String appID;
    private final Hashtable<String, List<String>> roleMap;
    private static final String CRLF = "\r\n";

    public MmUser(String username, String password, String appID, Hashtable<String, List<String>> roleMap) {
        this.username = username;
        this.password = password;
        this.appID = appID;
        this.roleMap = roleMap;
    }

    public String getPassword() {
        return this.password;
    }

    public Hashtable<String, List<String>> getRoleMap() {
        return this.roleMap;
    }

    public String getUsername() {
        return this.username;
    }

    public String getAppID() {
        return this.appID;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent + "<user name=" + this.getUsername() + CRLF);
        sb.append(indent + "<password>" + this.getPassword() + "</password>" + CRLF);
        sb.append(indent + "</user>");
        return sb.toString();
    }

    public LinkedList<String> getMethods(String objectName) {
        LinkedList method = (LinkedList)this.roleMap.get(objectName);
        if (method != null) {
            return method;
        }
        Set<Map.Entry<String, List<String>>> entrySet = this.roleMap.entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            if (!MmJMXServerSec.matchRule(objectName, entry.getKey())) continue;
            return (LinkedList)entry.getValue();
        }
        return null;
    }
}

