/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.authenticator;

import com.viettel.mmserver.agent.MMbeanServer;
import com.viettel.mmserver.authenticator.MmAuthenticatorMBean;
import com.viettel.mmserver.authenticator.MmUser;
import com.viettel.mmserver.base.Log;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.management.ObjectName;
import viettel.passport.client.ObjectToken;
import viettel.passport.client.VSAValidate;

public class MmAuthenticator
implements MmAuthenticatorMBean {
    public static final String PASSPORT_SERVICE_URL = "com.viettel.mmserver.passportServiceUrl";
    private VSAValidate vsa;
    private static MmAuthenticator mmAuthenticator;
    private final int timeOut = 30000;

    public static MmAuthenticator getInstance() {
        if (mmAuthenticator == null) {
            mmAuthenticator = new MmAuthenticator();
        }
        return mmAuthenticator;
    }

    private MmAuthenticator() {
        try {
            ObjectName name = new ObjectName("Tools:name=MmAuthenticator");
            MMbeanServer.getInstance().registerMBean(this, name);
            Log.info("Registered MmAuthenticator");
        }
        catch (Exception e) {
            Log.error("Can not register Mbean MmAuthenticator");
            Log.error(e);
        }
        Log.info("Creating VSAValidate...");
        this.vsa = new VSAValidate();
        String passportServiceUrl = System.getProperty(PASSPORT_SERVICE_URL);
        if (passportServiceUrl != null) {
            this.vsa.setCasValidateUrl(passportServiceUrl);
        }
        Log.info("Passport URL: " + this.vsa.getCasValidateUrl());
        this.vsa.setTimeOutVal(30000);
        Log.info("VSAValidate created!");
    }

    public MmUser validate(String username, String password, String appID) {
        Log.info("running validate");
        MmUser mmUser = null;
        this.vsa.setDomainCode(appID);
        this.vsa.setUser(username);
        this.vsa.setPassword(password);
        try {
            this.vsa.validate();
            Log.info("Validated");
            boolean result = this.vsa.isAuthenticationSuccesful();
            if (result) {
                Log.info("isAuthenticationSuccesful");
                Hashtable<String, List<String>> roleMap = new Hashtable<String, List<String>>();
                ArrayList objList = this.vsa.getUserToken().getParentMenu();
                for (Object ob : objList) {
                    if (!(ob instanceof ObjectToken)) continue;
                    LinkedList<String> temp = new LinkedList<String>();
                    ObjectToken element = (ObjectToken)ob;
                    String objectName = element.getObjectName();
                    ArrayList childs = element.getChildObjects();
                    if (childs != null) {
                        for (int i = 0; i < childs.size(); ++i) {
                            ObjectToken child = (ObjectToken)childs.get(i);
                            if (!"C".equalsIgnoreCase(child.getObjectType())) continue;
                            temp.add(child.getObjectName());
                        }
                    }
                    Log.info("$$$$$$$$$" + objectName + "............" + temp);
                    roleMap.put(objectName, temp);
                }
                Log.info("create mmUser");
                mmUser = new MmUser(username, password, appID, roleMap);
            }
            Log.info("isAuthenticationSuccesful");
        }
        catch (Exception e) {
            Log.error("Error in validate with Passport");
            Log.error(e);
            e.printStackTrace();
        }
        return mmUser;
    }

    private String formatCanonicalName(String name) {
        int index;
        String formatedName = name;
        if (name == null) {
            formatedName = "";
        }
        if ((index = name.indexOf(":")) != -1 && index < name.length()) {
            formatedName = name.substring(0, index + 1);
            String[] names = (name = name.substring(index + 1)).split(",");
            if (names.length > 0) {
                int i;
                for (i = 0; i < names.length - 1; ++i) {
                    for (int j = i + 1; j < names.length; ++j) {
                        if (names[i].compareTo(names[j]) <= 0) continue;
                        String temp = names[i];
                        names[i] = names[j];
                        names[j] = temp;
                    }
                }
                for (i = 0; i < names.length; ++i) {
                    formatedName = formatedName + names[i] + ",";
                }
                formatedName = formatedName.substring(0, formatedName.length() - 1);
            }
        }
        return formatedName;
    }

    public LinkedList<String> getAccessibleMethods(String appId, String userName, String password, String mBeanObjectName) {
        MmUser mmUser = this.validate(userName, password, appId);
        if (mmUser == null) {
            return null;
        }
        LinkedList<String> method = mmUser.getMethods(mBeanObjectName);
        if (method == null) {
            return new LinkedList<String>();
        }
        return method;
    }

    @Override
    public String vsaURL() {
        String s = "VSA's URL: ";
        s = this.vsa.getCasValidateUrl() != null ? s + this.vsa.getCasValidateUrl() : s + "Unknown";
        return s;
    }
}

