/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.LogFileCompressionStrategy;
import uk.org.simonsite.log4j.helpers.FileHelper;

final class ZipFileCompressionStrategy
extends LogFileCompressionStrategy {
    ZipFileCompressionStrategy() {
    }

    final String getAlgorithmName() {
        return "zip";
    }

    final boolean isCompressed(File backupFile) {
        return FileHelper.getInstance().isZip(backupFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean compress(File backupFile, File deflatedFile, AppenderRollingProperties properties) {
        long startTime;
        ZipOutputStream outputStream;
        FileInputStream inputStream;
        block11: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            inputStream = null;
                            outputStream = null;
                            try {
                                inputStream = this.createInputStream(backupFile);
                                if (inputStream != null) break block7;
                                boolean bl = false;
                                this.closeStreams(inputStream, outputStream);
                                return bl;
                            }
                            catch (Throwable throwable) {
                                this.closeStreams(inputStream, outputStream);
                                throw throwable;
                            }
                        }
                        outputStream = this.createOutputStream(deflatedFile, properties);
                        if (outputStream != null) break block8;
                        boolean bl = false;
                        this.closeStreams(inputStream, outputStream);
                        return bl;
                    }
                    startTime = System.currentTimeMillis();
                    if (this.openEntry(backupFile, outputStream)) break block9;
                    boolean bl = false;
                    this.closeStreams(inputStream, outputStream);
                    return bl;
                }
                if (this.addEntry(inputStream, outputStream)) break block10;
                boolean bl = false;
                this.closeStreams(inputStream, outputStream);
                return bl;
            }
            if (this.closeEntry(outputStream)) break block11;
            boolean bl = false;
            this.closeStreams(inputStream, outputStream);
            return bl;
        }
        LogLog.debug((String)("Compressed in " + (System.currentTimeMillis() - startTime) + "ms"));
        this.closeStreams(inputStream, outputStream);
        return true;
    }

    private FileInputStream createInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LogLog.debug((String)"Unable to open backup log file", (Throwable)e);
            return null;
        }
    }

    private ZipOutputStream createOutputStream(File deflatedFile, AppenderRollingProperties properties) {
        try {
            ZipOutputStream outputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(deflatedFile)));
            outputStream.setLevel(properties.getCompressionLevel());
            return outputStream;
        }
        catch (FileNotFoundException e) {
            LogLog.warn((String)"Unable to open compressed log file", (Throwable)e);
            return null;
        }
    }

    private void closeStreams(InputStream inputStream, OutputStream outputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LogLog.warn((String)"Unable to close backup log file", (Throwable)e);
            }
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                LogLog.warn((String)"Unable to close compressed log file", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addEntry(FileInputStream inputStream, ZipOutputStream outputStream) {
        FileChannel inputChannel = null;
        try {
            inputChannel = inputStream.getChannel();
            WritableByteChannel outputChannel = Channels.newChannel(outputStream);
            inputChannel.transferTo(0L, inputChannel.size(), outputChannel);
            boolean bl = true;
            return bl;
        }
        catch (ClosedByInterruptException e) {
            LogLog.debug((String)"Compression operation interrupted");
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LogLog.warn((String)"Unable to transfer data from backup log file to compressed log file", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputChannel != null) {
                try {
                    inputChannel.close();
                }
                catch (IOException e) {
                    LogLog.warn((String)"Unable to close backup log file", (Throwable)e);
                }
            }
        }
    }

    private boolean closeEntry(ZipOutputStream outputStream) {
        try {
            outputStream.closeEntry();
            outputStream.finish();
            return true;
        }
        catch (IOException e) {
            LogLog.warn((String)"Unable to complete log file compression", (Throwable)e);
            return false;
        }
    }

    private boolean openEntry(File file, ZipOutputStream outputStream) {
        try {
            ZipEntry zipEntry = new ZipEntry(file.getName());
            zipEntry.setMethod(8);
            outputStream.putNextEntry(zipEntry);
            return true;
        }
        catch (IOException e) {
            LogLog.warn((String)"Unable to add zip entry to compressed log file", (Throwable)e);
            return false;
        }
    }
}

