/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;

final class TimeSuffixHelper {
    private final AppenderRollingProperties properties;

    TimeSuffixHelper(AppenderRollingProperties properties) {
        this.properties = properties;
    }

    final long toTime(String filenameTimePart) {
        if ("".equals(filenameTimePart)) {
            return 0L;
        }
        try {
            return this.dateFormat().parse(filenameTimePart).getTime();
        }
        catch (ParseException e) {
            LogLog.warn((String)("Unable to parse date from filename " + filenameTimePart));
            return 0L;
        }
    }

    final String toString(long timeForSuffix) {
        return this.dateFormat().format(new Date(timeForSuffix));
    }

    private DateFormat dateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(this.properties.getDatePattern(), this.properties.getDatePatternLocale());
        df.setTimeZone(this.properties.getTimeZone());
        df.setLenient(false);
        return df;
    }
}

