/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.GzipFileCompressionStrategy;
import uk.org.simonsite.log4j.appender.ZipFileCompressionStrategy;
import uk.org.simonsite.log4j.helpers.FileHelper;

abstract class LogFileCompressionStrategy {
    static final LogFileCompressionStrategy ZIP = new ZipFileCompressionStrategy();
    static final LogFileCompressionStrategy GZIP = new GzipFileCompressionStrategy();
    static final LogFileCompressionStrategy DEFAULT = new LogFileCompressionStrategy(){

        boolean compress(File backupFile, File deflatedFile, AppenderRollingProperties properties) {
            return false;
        }

        String getAlgorithmName() {
            return "error";
        }

        boolean isCompressed(File backupFile) {
            return true;
        }
    };
    private static final LogFileCompressionStrategy[] COMPRESSION_STRATEGIES = new LogFileCompressionStrategy[]{ZIP, GZIP};

    LogFileCompressionStrategy() {
    }

    static final boolean existsFor(AppenderRollingProperties properties) {
        return !DEFAULT.equals(LogFileCompressionStrategy.findCompressionStrategy(properties));
    }

    static final LogFileCompressionStrategy findCompressionStrategy(AppenderRollingProperties properties) {
        if (ZIP.isRequiredStrategy(properties)) {
            LogLog.debug((String)"Using ZIP compression");
            return ZIP;
        }
        if (GZIP.isRequiredStrategy(properties)) {
            LogLog.debug((String)"Using GZIP compression");
            return GZIP;
        }
        LogLog.debug((String)"Not using compression");
        return DEFAULT;
    }

    static final LogFileCompressionStrategy[] strategies() {
        return COMPRESSION_STRATEGIES;
    }

    abstract boolean compress(File var1, File var2, AppenderRollingProperties var3);

    abstract String getAlgorithmName();

    abstract boolean isCompressed(File var1);

    final boolean isRequiredStrategy(AppenderRollingProperties properties) {
        return this.getAlgorithmName().equalsIgnoreCase(properties.getCompressionAlgorithm());
    }

    final File compress(File backupFile, AppenderRollingProperties properties) {
        if (this.isCompressed(backupFile)) {
            LogLog.debug((String)("Backup log file " + backupFile.getName() + " is already compressed"));
            return backupFile;
        }
        long lastModified = backupFile.lastModified();
        if (0L == lastModified) {
            LogLog.debug((String)("Backup log file " + backupFile.getName() + " may have been scavenged"));
            return null;
        }
        File deflatedFile = this.createDeflatedFile(backupFile);
        if (deflatedFile == null) {
            LogLog.debug((String)("Backup log file " + backupFile.getName() + " may have been scavenged"));
            return null;
        }
        if (this.compress(backupFile, deflatedFile, properties)) {
            deflatedFile.setLastModified(lastModified);
            FileHelper.getInstance().deleteExisting(backupFile);
            LogLog.debug((String)("Compressed backup log file to " + deflatedFile.getName()));
            return deflatedFile;
        }
        FileHelper.getInstance().deleteExisting(deflatedFile);
        LogLog.debug((String)("Unable to compress backup log file " + backupFile.getName()));
        return null;
    }

    private File createDeflatedFile(File backupFile) {
        try {
            FileHelper fileHelper = FileHelper.getInstance();
            File deflatedFile = new File(fileHelper.parentDirOf(backupFile), backupFile.getName() + '.' + this.getAlgorithmName());
            fileHelper.deleteExisting(deflatedFile);
            if (deflatedFile.createNewFile()) {
                return deflatedFile;
            }
            LogLog.warn((String)"Unable to create compressed backup log file");
            return null;
        }
        catch (IOException e) {
            LogLog.error((String)"Unable to create compressed backup log file", (Throwable)e);
            return null;
        }
    }
}

