/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.LogFileCompressionStrategy;
import uk.org.simonsite.log4j.helpers.FileHelper;

final class GzipFileCompressionStrategy
extends LogFileCompressionStrategy {
    private static final int DEFLATER_BUFFER_SIZE = 131071;

    GzipFileCompressionStrategy() {
    }

    final String getAlgorithmName() {
        return "gz";
    }

    final boolean isCompressed(File backupFile) {
        return FileHelper.getInstance().isGZip(backupFile);
    }

    final boolean compress(File backupFile, File deflatedFile, AppenderRollingProperties properties) {
        FileInputStream inputStream = this.createInputStream(backupFile);
        if (inputStream == null) {
            return false;
        }
        GZIPOutputStream outputStream = this.createGZipOutputStream(deflatedFile, properties);
        if (outputStream == null) {
            return false;
        }
        return this.compress(inputStream, outputStream);
    }

    private FileInputStream createInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LogLog.debug((String)"Unable to open backup log file", (Throwable)e);
            return null;
        }
    }

    private GZIPOutputStream createGZipOutputStream(File deflatedFile, AppenderRollingProperties properties) {
        try {
            return new GZIPOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(deflatedFile)), 131071);
        }
        catch (IOException e) {
            LogLog.warn((String)"Unable to open compressed log file", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compress(FileInputStream inputStream, GZIPOutputStream outputStream) {
        long startTime = System.currentTimeMillis();
        FileChannel inputChannel = null;
        WritableByteChannel outputChannel = null;
        try {
            inputChannel = inputStream.getChannel();
            outputChannel = Channels.newChannel(outputStream);
            inputChannel.transferTo(0L, inputChannel.size(), outputChannel);
            outputStream.finish();
        }
        catch (ClosedByInterruptException e) {
            LogLog.debug((String)"Compression operation interrupted");
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LogLog.warn((String)"Unable to transfer data from backup log file to compressed log file", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputChannel != null) {
                try {
                    inputChannel.close();
                }
                catch (IOException e) {
                    LogLog.warn((String)"Unable to close backup log file", (Throwable)e);
                }
            }
            if (outputChannel != null) {
                try {
                    outputChannel.close();
                }
                catch (IOException e) {
                    LogLog.warn((String)"Unable to close compressed log file", (Throwable)e);
                }
            }
        }
        LogLog.debug((String)("Compressed in " + (System.currentTimeMillis() - startTime) + "ms"));
        return true;
    }
}

