/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import org.apache.log4j.spi.LoggingEvent;
import uk.org.simonsite.log4j.appender.AbstractRoller;
import uk.org.simonsite.log4j.appender.FileRollable;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;
import uk.org.simonsite.log4j.helpers.FileHelper;

final class FileSizeRoller
extends AbstractRoller
implements FileRollable {
    FileSizeRoller(TimeAndSizeRollingAppender rollingAppender) {
        super(rollingAppender);
        this.initActualBytesWrittenCount();
    }

    public final boolean roll(LoggingEvent loggingEvent) {
        boolean rolled = false;
        if (this.isMaxFileSizeExceeded()) {
            super.roll(loggingEvent.getTimeStamp());
            rolled = true;
        }
        return rolled;
    }

    private boolean isMaxFileSizeExceeded() {
        return super.getProperties().getBytesWrittenCount() > super.getProperties().getMaxFileSize();
    }

    private long initActualBytesWrittenCount() {
        long byteCount = this.readActualBytesWrittenCount();
        super.getProperties().setBytesWrittenCount(byteCount);
        return byteCount;
    }

    private long readActualBytesWrittenCount() {
        File file = super.getAppender().getIoFile();
        if (file != null) {
            return FileHelper.getInstance().sizeOf(file);
        }
        super.getAppender().getErrorHandler().error("Bytes not counted: missing file name");
        return 0L;
    }
}

