/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.LogFileCompressionStrategy;
import uk.org.simonsite.log4j.appender.TimeSuffixHelper;

final class BackupSuffixHelper {
    private Pattern pattern = null;
    private final TimeSuffixHelper timeHelper;

    BackupSuffixHelper(AppenderRollingProperties properties) {
        this.timeHelper = new TimeSuffixHelper(properties);
    }

    final String defaultBackupCountAsString() {
        return Integer.toString(this.defaultBackupCount());
    }

    final String nextBackupCountAsString(String logFilename, File baseFile) {
        int oldBackupSuffixNumber = this.backupCount(logFilename, baseFile);
        return Integer.toString(oldBackupSuffixNumber + 1);
    }

    final Number[] backupTimeAndCount(String logFilename, File baseFile) {
        Pattern pattern = this.backupCountPattern(baseFile);
        Matcher matcher = pattern.matcher(logFilename);
        if (matcher.find()) {
            String timeStr = matcher.group(2);
            String countStr = matcher.group(4);
            long time = this.timeHelper.toTime(timeStr);
            int count = this.backupCountFromString(countStr);
            return new Number[]{time, count};
        }
        return new Number[]{0L, 0};
    }

    final String backupTimeAsString(String logFilename, File baseFile) {
        Pattern pattern = this.backupCountPattern(baseFile);
        Matcher matcher = pattern.matcher(logFilename);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return "";
    }

    final String backupTimeAsString(long timeForSuffix) {
        return this.timeHelper.toString(timeForSuffix);
    }

    private int backupCount(String logFilename, File baseFile) {
        String backupSuffix = this.backupCountAsString(logFilename, baseFile);
        return this.backupCountFromString(backupSuffix);
    }

    private String backupCountAsString(String logFilename, File baseFile) {
        Pattern pattern = this.backupCountPattern(baseFile);
        Matcher matcher = pattern.matcher(logFilename);
        if (matcher.find()) {
            return matcher.group(4);
        }
        return "";
    }

    private int backupCountFromString(String countStr) {
        if ("".equals(countStr)) {
            return 0;
        }
        try {
            return Integer.decode(countStr);
        }
        catch (NumberFormatException e) {
            return this.defaultBackupCount();
        }
    }

    private synchronized Pattern backupCountPattern(File baseFile) {
        if (this.pattern == null) {
            LogFileCompressionStrategy[] compressionStrategies = LogFileCompressionStrategy.strategies();
            StringBuffer patternBuffer = new StringBuffer();
            patternBuffer.append("(\\Q").append(baseFile.getName()).append("\\E)");
            patternBuffer.append("(.+)(\\.)([0-9]+)($");
            for (int i = 0; i < compressionStrategies.length; ++i) {
                patternBuffer.append("|\\.");
                patternBuffer.append(compressionStrategies[i].getAlgorithmName());
                patternBuffer.append('$');
            }
            patternBuffer.append(')');
            this.pattern = Pattern.compile(patternBuffer.toString());
        }
        return this.pattern;
    }

    private int defaultBackupCount() {
        return 1;
    }
}

