/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.util.Locale;
import java.util.TimeZone;
import uk.org.simonsite.log4j.helpers.SynchronizedCountingQuietWriter;

final class AppenderRollingProperties {
    private final Object compressionLock = new Object();
    private final Object countingWriterLock = new Object();
    private final Object scavengerLock = new Object();
    private final Object rollTimeLock = new Object();
    private final Object startupRollLock = new Object();
    private long maxFileSize = 0xA00000L;
    private int maxRollFileCount = 10;
    private String datePattern = "'.'yyyy-MM-dd";
    private Locale datePatternLocale = null;
    private TimeZone timeZone = null;
    private boolean dateRollEnforced = false;
    private long scavengeInterval = 30000L;
    private long minFreeDiscSpace = -1L;
    private String compressionAlgorithm = "";
    private int compressionLevel = 1;
    private long compressionMaxWait = 30000L;
    private int compressionMinQueueSize = 0;
    private boolean compressionBlocking = false;
    private SynchronizedCountingQuietWriter countingQuietWriter = null;
    private long nextRollOverTime = 0L;
    private boolean rollOnStartup = false;
    private boolean rolledOnStartup = false;
    private boolean activatingAppender = false;
    private String datePatternJump = "00:00:00";
    private long jumpStep = 0L;
    private long randomRangeForShift = 1800L;
    private long rollingCyleShiftValue = 0L;

    AppenderRollingProperties() {
    }

    final boolean isActivatingAppender() {
        return this.activatingAppender;
    }

    final void setActivatingAppender(boolean activatingAppender) {
        this.activatingAppender = activatingAppender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long getBytesWrittenCount() {
        Object object = this.countingWriterLock;
        synchronized (object) {
            return this.countingQuietWriter != null ? this.countingQuietWriter.getCount() : 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setBytesWrittenCount(long byteCount) {
        Object object = this.countingWriterLock;
        synchronized (object) {
            if (this.countingQuietWriter != null) {
                this.countingQuietWriter.setCount(byteCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SynchronizedCountingQuietWriter getCountingQuietWriter() {
        Object object = this.countingWriterLock;
        synchronized (object) {
            return this.countingQuietWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCountingQuietWriter(SynchronizedCountingQuietWriter countingQuietWriter) {
        Object object = this.countingWriterLock;
        synchronized (object) {
            this.countingQuietWriter = countingQuietWriter;
        }
    }

    final String getDatePattern() {
        return this.datePattern != null ? this.datePattern : "";
    }

    final void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    final Locale getDatePatternLocale() {
        return this.datePatternLocale != null ? this.datePatternLocale : Locale.ENGLISH;
    }

    final void setDatePatternLocale(Locale datePatternLocale) {
        this.datePatternLocale = datePatternLocale;
    }

    final TimeZone getTimeZone() {
        return this.timeZone != null ? this.timeZone : TimeZone.getDefault();
    }

    final void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    final boolean isDateRollEnforced() {
        return this.dateRollEnforced;
    }

    final void setDateRollEnforced(boolean dateRollEnforced) {
        this.dateRollEnforced = dateRollEnforced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long getNextRollOverTime() {
        long time = 0L;
        Object object = this.rollTimeLock;
        synchronized (object) {
            time = this.nextRollOverTime;
            this.rollTimeLock.notifyAll();
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long getNextRollOverTimeWithWait() {
        long time = 0L;
        Object object = this.rollTimeLock;
        synchronized (object) {
            while (this.nextRollOverTime == 0L) {
                try {
                    this.rollTimeLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            time = this.nextRollOverTime;
            this.rollTimeLock.notifyAll();
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setNextRollOverTime(long nextRollOverTime) {
        Object object = this.rollTimeLock;
        synchronized (object) {
            this.nextRollOverTime = nextRollOverTime;
            this.rollTimeLock.notifyAll();
        }
    }

    final synchronized long getMaxFileSize() {
        return this.maxFileSize;
    }

    final synchronized void setMaxFileSize(long maxFileSize) {
        if (maxFileSize >= 0L) {
            this.maxFileSize = maxFileSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean shouldRollOnStartup() {
        Object object = this.startupRollLock;
        synchronized (object) {
            return this.rollOnStartup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setRollOnStartup(boolean rollOnStartup) {
        Object object = this.startupRollLock;
        synchronized (object) {
            this.rollOnStartup = rollOnStartup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean wasRolledOnStartup() {
        Object object = this.startupRollLock;
        synchronized (object) {
            return this.rolledOnStartup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean updateRolledOnStartup() {
        Object object = this.startupRollLock;
        synchronized (object) {
            if (this.rolledOnStartup) {
                return false;
            }
            this.rolledOnStartup = true;
            return this.rollOnStartup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean shouldRollOnActivation() {
        Object object = this.startupRollLock;
        synchronized (object) {
            return this.rollOnStartup && !this.rolledOnStartup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getMaxRollFileCount() {
        Object object = this.scavengerLock;
        synchronized (object) {
            return this.maxRollFileCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setMaxRollFileCount(int maxRollFileCount) {
        Object object = this.scavengerLock;
        synchronized (object) {
            if (maxRollFileCount >= 0) {
                this.maxRollFileCount = maxRollFileCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long getMinFreeDiscSpace() {
        Object object = this.scavengerLock;
        synchronized (object) {
            return this.minFreeDiscSpace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setMinFreeDiscSpace(long minFreeDiskSpace) {
        Object object = this.scavengerLock;
        synchronized (object) {
            if (minFreeDiskSpace >= 0L) {
                this.minFreeDiscSpace = minFreeDiskSpace;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long getScavengeInterval() {
        Object object = this.scavengerLock;
        synchronized (object) {
            return this.scavengeInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setScavengeInterval(long scavengeInterval) {
        Object object = this.scavengerLock;
        synchronized (object) {
            if (scavengeInterval >= -1L) {
                this.scavengeInterval = scavengeInterval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String getCompressionAlgorithm() {
        Object object = this.compressionLock;
        synchronized (object) {
            return this.compressionAlgorithm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCompressionAlgorithm(String compressionAlgorithm) {
        Object object = this.compressionLock;
        synchronized (object) {
            this.compressionAlgorithm = compressionAlgorithm != null ? compressionAlgorithm.trim() : "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long getCompressionMaxWait() {
        Object object = this.compressionLock;
        synchronized (object) {
            return this.compressionMaxWait;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCompressionMaxWait(long compressionMaxWait) {
        Object object = this.compressionLock;
        synchronized (object) {
            if (compressionMaxWait >= 0L) {
                this.compressionMaxWait = compressionMaxWait;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getCompressionLevel() {
        Object object = this.compressionLock;
        synchronized (object) {
            return this.compressionLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCompressionLevel(int compressionLevel) {
        Object object = this.compressionLock;
        synchronized (object) {
            if (compressionLevel >= -1 && compressionLevel <= 9) {
                this.compressionLevel = compressionLevel;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isCompressionBlocking() {
        Object object = this.compressionLock;
        synchronized (object) {
            return this.compressionBlocking;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCompressionBlocking(boolean compressionBlocks) {
        Object object = this.compressionLock;
        synchronized (object) {
            this.compressionBlocking = compressionBlocks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getCompressionMinQueueSize() {
        Object object = this.compressionLock;
        synchronized (object) {
            return this.compressionMinQueueSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCompressionMinQueueSize(int compressionMinQueueSize) {
        Object object = this.compressionLock;
        synchronized (object) {
            if (compressionMinQueueSize >= 0) {
                this.compressionMinQueueSize = compressionMinQueueSize;
            }
        }
    }

    public final String getDatePatternJump() {
        return this.datePatternJump;
    }

    public final void setDatePatternJump(String datePatternJump) {
        this.datePatternJump = datePatternJump;
    }

    public long getJumpStep() {
        return this.jumpStep;
    }

    public void setJumpStep(long jumpStep) {
        this.jumpStep = jumpStep;
    }

    public long getRandomRangeForShift() {
        return this.randomRangeForShift;
    }

    public void setRandomRangeForShift(long radomRangeForShift) {
        this.randomRangeForShift = radomRangeForShift;
    }

    public long getRollingCyleShiftValue() {
        return this.rollingCyleShiftValue;
    }

    public void setRollingCyleShiftValue(long rollingCyleShiftValue) {
        this.rollingCyleShiftValue = rollingCyleShiftValue;
    }
}

