/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AbstractLogFileScavenger;
import uk.org.simonsite.log4j.appender.LogFileList;
import uk.org.simonsite.log4j.helpers.FileHelper;

public final class AbsoluteMinFreeDiskSpaceLogFileScavenger
extends AbstractLogFileScavenger {
    public void scavenge() {
        long minFreeDiscSpace;
        LogFileList logFileList = super.logFileList();
        if (logFileList.size() == 0) {
            return;
        }
        long usableDiscSpace = logFileList.firstFile().getUsableSpace();
        if (usableDiscSpace < (minFreeDiscSpace = this.getProperties().getMinFreeDiscSpace())) {
            long needToFree = minFreeDiscSpace - usableDiscSpace;
            LogLog.debug((String)("Need to free " + needToFree + " bytes to get the configured minimum of " + minFreeDiscSpace + " bytes free disc space"));
            FileHelper fileHelper = FileHelper.getInstance();
            long freeableDiscSpace = 0L;
            int lastToBeDeleted = -1;
            for (File logFile : logFileList) {
                ++lastToBeDeleted;
                if ((freeableDiscSpace += logFile.length()) < needToFree) continue;
                break;
            }
            if (lastToBeDeleted == -1) {
                LogLog.debug((String)("Should free " + needToFree + " bytes, but not deletable logfiles found"));
                return;
            }
            if (lastToBeDeleted >= 0) {
                LogLog.debug((String)("About to delete " + (lastToBeDeleted + 1) + " log file(s) which will recover " + freeableDiscSpace + " bytes on disk."));
            }
            long freed = 0L;
            for (int d = 0; d <= lastToBeDeleted; ++d) {
                File logFile = (File)logFileList.get(d);
                long size = logFile.length();
                if (!fileHelper.deleteExisting(logFile)) continue;
                LogLog.debug((String)("Scavenged log file '" + logFile.getName() + "', freed " + size + " bytes."));
                freed += size;
            }
            LogLog.debug((String)("Totally freed " + freed + " bytes."));
        } else {
            LogLog.debug((String)("No need to scavenge log files: " + (usableDiscSpace - minFreeDiscSpace) + " bytes of disk space available for log files"));
        }
    }
}

