/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mm.plugin.logserver;

import com.viettel.mm.logagent.Log;
import com.viettel.mm.plugin.logserver.LogRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempLogRepository
implements LogRepository {
    Map<String, Queue<Log>> tempLogs = new HashMap<String, Queue<Log>>();
    public static final int DEFAULT_QUEUE_MAX_SIZE = 100;
    private int queueMaxSize = 100;
    public static final int DEFAULT_MAX_QUEUE = 300;
    private int maxQueue = 300;
    private static TempLogRepository instance = null;
    private final Object lock = new Object();

    private TempLogRepository() {
    }

    public static synchronized TempLogRepository getInstance() {
        if (instance == null) {
            instance = new TempLogRepository();
        }
        return instance;
    }

    public int getCurentQueues() {
        return this.tempLogs.size();
    }

    public int getMaxQueue() {
        return this.maxQueue;
    }

    public void setMaxQueue(int maxQueue) {
        this.maxQueue = maxQueue;
    }

    public int getQueueMaxSize() {
        return this.queueMaxSize;
    }

    public void setQueueMaxSize(int queueMaxSize) {
        this.queueMaxSize = queueMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Log log) {
        Object object = this.lock;
        synchronized (object) {
            Queue<Log> logs = this.tempLogs.get(log.getLoggerName());
            if (logs == null) {
                if (this.tempLogs.size() < this.maxQueue) {
                    logs = new LinkedList<Log>();
                    this.tempLogs.put(log.getLoggerName(), logs);
                } else {
                    return;
                }
            }
            if (logs.size() >= this.queueMaxSize) {
                logs.remove();
            }
            logs.add(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Log> getLog(String applicationID) {
        Object object = this.lock;
        synchronized (object) {
            Queue<Log> logs = this.tempLogs.get(applicationID);
            if (logs == null) {
                return null;
            }
            ArrayList<Log> returnLog = new ArrayList<Log>();
            if (!logs.isEmpty()) {
                returnLog.add(logs.remove());
            }
            return returnLog;
        }
    }
}

