/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mm.plugin.logserver;

import com.viettel.mm.logagent.Log;
import com.viettel.mm.plugin.logserver.ServerSocketListener;
import com.viettel.mm.plugin.logserver.SocketReaderManager;
import com.viettel.mm.plugin.logserver.TempLogRepository;
import com.viettel.mmserver.base.ProcessThreadMX;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.Socket;

public class SocketReader
extends ProcessThreadMX {
    private SocketReaderManager swm;
    private Socket socket;
    private ObjectInputStream objectInputStream;
    private TempLogRepository tempLogRepository;

    public void start() {
        super.start();
        try {
            this.registerAgent("MM:plugin=Log,name=SocketReader" + ServerSocketListener.getSocketid());
        }
        catch (Exception ex) {
            this.logger.error((Object)("Can not register Mbean for Socket Reader: " + ex));
        }
    }

    public void setSwm(SocketReaderManager swm) {
        this.swm = swm;
    }

    public TempLogRepository getTempLogRepository() {
        return this.tempLogRepository;
    }

    public void setTempLogRepository(TempLogRepository tempLogRepository) {
        this.tempLogRepository = tempLogRepository;
    }

    public SocketReader(Socket socket) {
        super("SocketReader");
        this.socket = socket;
    }

    protected void prepareStart() {
        try {
            if (this.objectInputStream == null) {
                this.logger.info((Object)("Trying read log from " + this.socket.getInetAddress()));
                InputStream inputStream = this.socket.getInputStream();
                this.logger.info((Object)"Creating object input stream ... ");
                this.objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
                this.logger.info((Object)"Created object input stream ...");
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.logger.error((Object)("Error when create object input stream from socket " + this.socket.getInetAddress() + " " + ex));
        }
    }

    protected void process() {
        block18: {
            try {
                if (this.objectInputStream != null) {
                    Object log = null;
                    try {
                        this.logger.info((Object)"Waiting for log.....");
                        log = this.objectInputStream.readObject();
                        this.logger.info((Object)("Get " + log));
                        if (log instanceof Log) {
                            Log logx = (Log)log;
                            TempLogRepository.getInstance().store(logx);
                        } else {
                            this.logger.info((Object)"ko phai log");
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        this.logger.error((Object)"Error when read object from socket ", ex);
                        if (this.objectInputStream != null) {
                            try {
                                this.objectInputStream.close();
                            }
                            catch (Exception e) {
                                this.logger.error((Object)"Error when close object input stream ", (Throwable)e);
                            }
                        }
                        if (this.socket != null) {
                            try {
                                this.socket.close();
                            }
                            catch (Exception e) {
                                this.logger.error((Object)"Error when close socket ", (Throwable)e);
                            }
                        }
                        this.stop();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        this.logger.error((Object)ex);
                    }
                    break block18;
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Error when close socket " + e));
                    }
                }
                this.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void stop() {
        this.swm.removeSocketReader(this);
        try {
            this.unregisterAgent();
            super.stop();
        }
        catch (Exception ex) {
            this.logger.error((Object)("Error when stop socket reader: " + (Object)((Object)this) + ". "), (Throwable)ex);
        }
    }

    public String getInfor() {
        StringBuilder sb = new StringBuilder();
        sb.append("Address: ");
        sb.append(this.socket.getInetAddress());
        sb.append(" Status: ");
        sb.append(this.getStatusDesc());
        return sb.toString();
    }
}

