/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mm.plugin.logserver;

import com.viettel.mm.plugin.logserver.SocketReaderManager;
import com.viettel.mmserver.base.ProcessThreadMX;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class ServerSocketListener
extends ProcessThreadMX {
    public static final int SLEEP_TIME = 1000;
    private int port;
    private ServerSocket serverSocket = null;
    private SocketReaderManager swm = null;
    private static int socketid = 1;

    public static synchronized int getSocketid() {
        return socketid++;
    }

    public ServerSocketListener(int port) {
        super("ServerMonitor");
        try {
            this.registerAgent("Tools:type=log,name=SocketListener");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.port = port;
        this.swm = SocketReaderManager.getInstance();
    }

    protected void process() {
        Socket socket = null;
        try {
            if (this.serverSocket == null || this.serverSocket.isClosed()) {
                this.serverSocket = new ServerSocket(this.port);
            }
            if (this.serverSocket == null) {
                Thread.sleep(1000L);
            }
            if (this.serverSocket != null) {
                socket = this.serverSocket.accept();
            }
        }
        catch (InterruptedIOException e) {
            System.out.println("exception accepting socket." + e);
        }
        catch (SocketException e) {
            System.out.println("Exception when acceptting new socket");
        }
        catch (IOException e) {
            System.out.println("exception accepting socket." + e);
        }
        catch (Exception e) {
            System.out.println("exception accepting socket." + e);
        }
        catch (Throwable tt) {
            System.out.println("exception accepting socket." + tt);
        }
        if (socket != null) {
            if (this.swm != null) {
                this.swm.addSocketReader(socket);
            }
        } else {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                this.stop();
                this.logger.error((Object)ex);
            }
        }
    }

    protected void prepareStart() {
        if (this.serverSocket == null) {
            try {
                this.serverSocket = new ServerSocket(this.port);
            }
            catch (Exception e) {
                System.out.println("exception when create server socket." + e);
            }
        }
    }

    public void stop() {
        if (this.serverSocket != null) {
            System.out.println("Stoping server socket");
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                System.out.println("Could not stop server Socket at port " + this.port + ". " + ex);
            }
        }
        super.stop();
    }

    public void setSwm(SocketReaderManager swm) {
        this.swm = swm;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

