/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.webservice;

import com.viettel.ussdfw.database.ConnectionPoolManager;
import com.viettel.ussdfw.database.DbProcessorFW;
import com.viettel.ussdfw.log.ProcessTransLog;
import com.viettel.ussdfw.object.TransactionLog;
import com.viettel.ussdfw.object.WebserviceMsg;
import com.viettel.ussdfw.object.WebserviceObject;
import com.viettel.ussdfw.webservice.HttpClientManager;
import com.viettel.ussdfw.webservice.WebserviceActiveProcessor;
import com.viettel.ussdfw.webservice.WebserviceGroup;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WebserviceFW {
    protected HttpClientManager httpclientManager;
    protected Logger logger;
    protected StringBuffer br = new StringBuffer();
    protected String loggerLabel = "WebserviceFW: ";
    protected long timeSt;
    protected long timeEx;
    private int CONNECTION_TIME_OUT = 60000;
    private int WS_ACTIVE_IDLE = 10000;
    private int NUMER_HTTPCLIENT = 1;
    private DbProcessorFW dbProcessor;
    private String dbId;
    private DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
    private DocumentBuilder db = this.df.newDocumentBuilder();
    private static HashMap<String, WebserviceGroup> mapWsCode = null;
    private static WebserviceActiveProcessor wsActive = null;

    public WebserviceFW(Logger logger, String pathWSConfig, String pathDatabaseConfig, boolean checkActive) throws Exception {
        this.logger = logger;
        logger.info((Object)"Init Webservice");
        this.loadConfig(pathWSConfig);
        this.loadConfigDb(pathDatabaseConfig);
        this.httpclientManager = new HttpClientManager(this.NUMER_HTTPCLIENT, this.CONNECTION_TIME_OUT);
        if (checkActive && wsActive == null) {
            wsActive = new WebserviceActiveProcessor("WSActive", this.CONNECTION_TIME_OUT, this.WS_ACTIVE_IDLE);
            wsActive.start();
        }
    }

    public WebserviceFW(Logger logger, String pathWSConfig, String pathDatabaseConfig) throws Exception {
        this.logger = logger;
        logger.info((Object)"Init Webservice");
        this.loadConfig(pathWSConfig);
        this.loadConfigDb(pathDatabaseConfig);
        this.httpclientManager = new HttpClientManager(this.NUMER_HTTPCLIENT, this.CONNECTION_TIME_OUT);
        if (wsActive == null) {
            wsActive = new WebserviceActiveProcessor("WSActive", this.CONNECTION_TIME_OUT, this.WS_ACTIVE_IDLE);
            wsActive.start();
        }
    }

    public WebserviceFW(Logger logger, String pathWSConfig) throws Exception {
        this.logger = logger;
        logger.info((Object)"Init Webservice");
        this.loadConfig(pathWSConfig);
        this.loadConfigDb("../etc/database.xml");
        this.httpclientManager = new HttpClientManager(this.NUMER_HTTPCLIENT, this.CONNECTION_TIME_OUT);
        if (wsActive == null) {
            wsActive = new WebserviceActiveProcessor("WSActive", this.CONNECTION_TIME_OUT, this.WS_ACTIVE_IDLE);
            wsActive.start();
        }
    }

    private void loadConfig(String path) throws Exception {
        Properties pro = new Properties();
        FileReader fileReader = null;
        fileReader = new FileReader(path);
        pro.load(fileReader);
        try {
            this.CONNECTION_TIME_OUT = Integer.parseInt(pro.getProperty("CONNECTION_TIME_OUT", "60000"));
            this.WS_ACTIVE_IDLE = Integer.parseInt(pro.getProperty("WS_ACTIVE_IDLE", "10000"));
            this.NUMER_HTTPCLIENT = Integer.parseInt(pro.getProperty("NUMER_HTTPCLIENT", "1"));
        }
        catch (Exception ex) {
            this.logger.error((Object)("ERROR when read " + path), (Throwable)ex);
        }
        try {
            this.dbId = pro.getProperty("DATABASE_ID");
            if (this.dbId == null || this.dbId.length() <= 0) {
                this.logger.error((Object)("DATABASE_ID need config in " + path + "\n"));
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("DATABASE_ID not found in " + path + "\n"));
            throw ex;
        }
    }

    private void loadConfigDb(String path) throws Exception {
        ConnectionPoolManager.loadConfig(path);
        if (mapWsCode == null) {
            this.dbProcessor = new DbProcessorFW(this.logger);
            mapWsCode = this.dbProcessor.iGetWebservice(this.dbId);
        }
    }

    protected void reloadConfigDb() throws Exception {
        if (this.dbProcessor == null) {
            this.dbProcessor = new DbProcessorFW(this.logger);
        }
        mapWsCode = this.dbProcessor.iGetWebservice(this.dbId);
    }

    private void setInactiveWS(WebserviceObject wsObj) {
        WebserviceGroup wsGroup = mapWsCode.get(wsObj.getWsCode());
        if (wsGroup != null) {
            this.logger.info((Object)("set inactive WS id:" + wsObj.getWsId()));
            wsGroup.setInActiveWS(wsObj);
        }
    }

    public static void setActiveWS(WebserviceObject wsObj) {
        WebserviceGroup wsGroup = mapWsCode.get(wsObj.getWsCode());
        if (wsGroup != null) {
            wsGroup.setActiveWS(wsObj);
        }
    }

    public WebserviceObject getWebservice(String wsCode) {
        WebserviceObject wsObj = null;
        WebserviceGroup wsGroup = mapWsCode.get(wsCode);
        if (wsGroup == null) {
            this.logger.warn((Object)("Don't exits ws_code: " + wsCode + " => return null"));
        } else {
            wsObj = wsGroup.getWebservice();
        }
        return wsObj;
    }

    public WebserviceMsg send(WebserviceMsg request, WebserviceObject wsObj) {
        return this.send(request, wsObj, null, true);
    }

    public WebserviceMsg send(WebserviceMsg request, WebserviceObject wsObj, boolean writeLog) {
        return this.send(request, wsObj, null, writeLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebserviceMsg send(WebserviceMsg request, WebserviceObject wsObj, HashMap<String, String> headerMap, boolean writeLog) {
        WebserviceMsg wsMsg = new WebserviceMsg();
        wsMsg.setRequest(request.getRequest());
        wsMsg.setResponse("000");
        String requestType = "";
        if (wsObj == null) {
            this.logger.error((Object)"Webservice is null");
            return wsMsg;
        }
        if (request.getRequest() == null || request.getRequest().length() == 0) {
            this.logger.error((Object)"request is null");
            return wsMsg;
        }
        requestType = wsObj.getRequestType() != null && !wsObj.getRequestType().isEmpty() ? wsObj.getRequestType() : (request.getRequest().trim().startsWith("{") ? "application/json" : "text/xml");
        String wsdl = wsObj.getWsdl();
        if (request.getMsisdn() != null) {
            wsdl = wsdl.replace("#MSISDN#", request.getMsisdn());
        }
        TransactionLog log = new TransactionLog();
        log.setMsisdn(request.getMsisdn());
        log.setType(3);
        log.setRequest(request.getRequest());
        log.setCommand(wsObj.getWsCode());
        log.setErrorCode("000");
        log.setChannel(wsdl);
        PostMethod post = null;
        try {
            String line;
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception sc) {
                // empty catch block
            }
            this.setTimeSt(System.currentTimeMillis());
            log.setRequestTime(new Timestamp(System.currentTimeMillis()));
            this.logger.info((Object)("WS: " + wsdl));
            this.logger.info((Object)("REQUEST: " + request.getRequest()));
            post = new PostMethod(wsdl);
            StringRequestEntity entity = new StringRequestEntity(request.getRequest(), requestType, "UTF-8");
            post.setRequestEntity((RequestEntity)entity);
            if (headerMap != null && !headerMap.isEmpty()) {
                for (String key : headerMap.keySet()) {
                    Header header = new Header(key, headerMap.get(key));
                    post.addRequestHeader(header);
                }
            }
            this.httpclientManager.getChannel().executeMethod((HttpMethod)post);
            InputStream responseStream = post.getResponseBodyAsStream();
            InputStreamReader reader = new InputStreamReader(responseStream, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(reader);
            StringBuilder responseBuilder = new StringBuilder();
            while ((line = br.readLine()) != null) {
                responseBuilder.append(line);
            }
            String response = responseBuilder.toString();
            wsMsg.setResponse(response);
            log.setResponse(response.length() >= 4000 ? response.substring(0, 3999) : response);
            log.setResponseTime(new Timestamp(System.currentTimeMillis()));
            if (response.equals("\u0000")) {
                throw new Exception("Webservice not avaiable " + wsdl);
            }
            wsMsg.setHttpCode(post.getStatusLine().getStatusCode() + "");
            this.logger.info((Object)("RESPONSE: " + response));
            if (response.startsWith("{")) {
                if (post.getStatusLine().getStatusCode() != 200 && post.getStatusLine().getStatusCode() != 202) {
                    log.setErrorCode(post.getStatusLine().getStatusCode() + "");
                    this.logger.info((Object)("HTTP ERROR CODE: " + post.getStatusLine().getStatusCode()));
                } else {
                    String[] resErrorTree = wsObj.getErrorTag().split(",");
                    JSONObject obj = new JSONObject(response);
                    if (resErrorTree.length > 1) {
                        for (int i = 0; i < resErrorTree.length - 1; ++i) {
                            obj = obj.getJSONObject(resErrorTree[i]);
                        }
                    }
                    try {
                        String errorCode = obj.get(resErrorTree[resErrorTree.length - 1]) == JSONObject.NULL ? "" : obj.get(resErrorTree[resErrorTree.length - 1]).toString();
                        log.setErrorCode(errorCode);
                    }
                    catch (Exception errorCode) {}
                }
            } else if (response.length() > 0) {
                InputSource is = new InputSource(new StringReader(response));
                Document dc = this.db.parse(is);
                Element root = dc.getDocumentElement();
                wsMsg.setDcElement(root);
                String errorTag = wsObj.getErrorTag() == null ? "errorCode" : wsObj.getErrorTag();
                String errorCode = wsMsg.getProperty(errorTag);
                if (errorCode == null || errorCode.isEmpty()) {
                    String error;
                    String errorBccsGw = wsMsg.getProperty("error");
                    errorCode = errorBccsGw == null ? "" : (!errorBccsGw.equals("0") ? errorBccsGw : (error = wsMsg.getProperty("return")));
                }
                errorCode = errorCode.split("\\|")[0];
                log.setErrorCode(errorCode);
                this.logger.info((Object)(" ERROR_CODE: " + errorCode));
            } else {
                log.setErrorCode(wsMsg.getHttpCode());
            }
        }
        catch (IOException ex) {
            this.logger.error((Object)("IOException when send to ws: " + wsdl), (Throwable)ex);
            log.setResponseTime(new Timestamp(System.currentTimeMillis()));
            log.setErrorCode("001");
            wsMsg.setResponse("001");
            this.setInactiveWS(wsObj);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Exception when send to ws: " + wsdl), (Throwable)ex);
            log.setResponseTime(new Timestamp(System.currentTimeMillis()));
            log.setErrorCode("000");
            this.setInactiveWS(wsObj);
        }
        finally {
            wsMsg.setErrorCode(log.getErrorCode());
            this.logTime("Time to " + wsObj.getWsCode());
            if (writeLog) {
                ProcessTransLog.enqueue(log);
            }
            try {
                if (post != null) {
                    post.releaseConnection();
                }
            }
            catch (Exception ex) {}
        }
        return wsMsg;
    }

    public void setTimeSt(long timeSt) {
        this.timeSt = timeSt;
    }

    public void logTime(String strLog) {
        this.timeEx = System.currentTimeMillis() - this.timeSt;
        this.br.setLength(0);
        this.br.append(this.loggerLabel).append(strLog).append(": ").append(this.timeEx).append(" ms");
        this.logger.info((Object)this.br);
    }
}

