/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.webservice;

import com.viettel.mmserver.base.ProcessThreadMX;
import com.viettel.ussdfw.manager.AppManager;
import com.viettel.ussdfw.object.WebserviceObject;
import com.viettel.ussdfw.webservice.WebserviceFW;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import utils.BlockQueue;

public class WebserviceActiveProcessor
extends ProcessThreadMX {
    private static BlockQueue queue;
    private HttpClient httpclient;
    private int CONNECTION_TIME_OUT;
    private int WS_ACTIVE_IDLE = 10000;

    public WebserviceActiveProcessor(String threadName, int connectionTimeout, int wsActiveIdle) {
        super(threadName);
        try {
            this.registerAgent(AppManager.appId + ":type=WebserviceActiveProcessor,name=" + threadName);
            this.httpclient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            this.httpclient.getParams().setSoTimeout(this.CONNECTION_TIME_OUT);
            this.httpclient.getParams().setConnectionManagerTimeout((long)this.CONNECTION_TIME_OUT);
            this.httpclient.getHttpConnectionManager().getParams().setConnectionTimeout(this.CONNECTION_TIME_OUT);
            this.CONNECTION_TIME_OUT = connectionTimeout;
            this.WS_ACTIVE_IDLE = wsActiveIdle;
            queue = new BlockQueue(0, 1000);
        }
        catch (Exception ex) {
            this.logger.error((Object)"error when init thread active ws", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkActive(WebserviceObject obj) {
        BlockQueue blockQueue = queue;
        synchronized (blockQueue) {
            queue.enqueue((Object)obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        if (queue.size() > 0) {
            this.logger.info((Object)"Check ws is running.....");
            WebserviceObject wsObj = (WebserviceObject)queue.dequeue();
            String url = wsObj.getWsdl();
            if (this.callWs(url, wsObj.getMsgTemplate())) {
                wsObj.setActive(true);
                WebserviceFW.setActiveWS(wsObj);
            } else {
                BlockQueue blockQueue = queue;
                synchronized (blockQueue) {
                    queue.enqueue((Object)wsObj);
                }
            }
            try {
                Thread.sleep(this.WS_ACTIVE_IDLE);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            try {
                Thread.sleep(this.WS_ACTIVE_IDLE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean callWs(String url, String reqContent) {
        boolean active = false;
        String result = "";
        String response = "";
        PostMethod post = new PostMethod(url);
        try {
            this.logger.info((Object)("WSDL:" + url));
            String requestType = "";
            requestType = reqContent.trim().startsWith("{") ? "application/json" : "text/xml";
            StringRequestEntity entity = new StringRequestEntity(reqContent, requestType, "UTF-8");
            post.setRequestEntity((RequestEntity)entity);
            this.httpclient.executeMethod((HttpMethod)post);
            result = post.getResponseBodyAsString();
            if (result.equals("\u0000")) {
                throw new Exception("Webservice not avaiable " + url);
            }
            this.logger.debug((Object)"\n*********************\n");
            this.logger.debug((Object)("Post :" + reqContent));
            this.logger.debug((Object)("Resut :" + result));
            this.logger.debug((Object)"\n*********************\n");
            this.logger.info((Object)("ws : " + url + "is active"));
            active = true;
        }
        catch (Exception e) {
            active = false;
            this.logger.info((Object)("ws:" + url + "is inactive"));
            e.printStackTrace();
        }
        post.releaseConnection();
        post = null;
        return active;
    }
}

