/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.process;

import com.viettel.application.ussdapp.common.VasRequest;
import com.viettel.application.ussdapp.common.VasResponse;
import com.viettel.application.ussdapp.vasinterface.tcp.TCPConnector;
import java.util.HashMap;
import java.util.Map;
import utils.BlockQueue;

public class Dispatcher {
    private String name;
    private HashMap<String, String> fileConfig;
    private HashMap<Integer, TCPConnector> mapConnector;
    private BlockQueue queue;
    private static HashMap<String, Dispatcher> hmInstance = new HashMap();

    public Dispatcher(String name, int queueSize, HashMap<String, String> listFileConfig) throws Exception {
        this.name = name;
        this.fileConfig = listFileConfig;
        this.queue = new BlockQueue(0, queueSize);
        this.mapConnector = new HashMap();
        int index = 0;
        for (Map.Entry<String, String> entry : listFileConfig.entrySet()) {
            String fileConfig = entry.getValue();
            String cpId = entry.getKey();
            TCPConnector connector = new TCPConnector(Integer.parseInt(cpId), name + "_" + cpId, fileConfig);
            connector.setQueue(this.queue);
            this.mapConnector.put(Integer.parseInt(cpId), connector);
            ++index;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized VasRequest getRequest() {
        return (VasRequest)this.queue.dequeue();
    }

    public void sendResponse(VasResponse vasResponse) throws Exception {
        TCPConnector connector = this.mapConnector.get(vasResponse.getConnectorId());
        connector.sendResponse(vasResponse);
    }

    public static HashMap<String, Dispatcher> getHmInstance() {
        return hmInstance;
    }

    public static void setHmInstance(HashMap<String, Dispatcher> hmInstance) {
        Dispatcher.hmInstance = hmInstance;
    }

    public HashMap<Integer, TCPConnector> getMapConnector() {
        return this.mapConnector;
    }

    public void setMapConnector(HashMap<Integer, TCPConnector> mapConnector) {
        this.mapConnector = mapConnector;
    }

    public BlockQueue getQueue() {
        return this.queue;
    }

    public void setQueue(BlockQueue queue) {
        this.queue = queue;
    }

    public static Dispatcher getInstance(String name, int queueSize, HashMap<String, String> fileConfig) throws Exception {
        if (!hmInstance.containsKey(name)) {
            hmInstance.put(name, new Dispatcher(name, queueSize, fileConfig));
        }
        return hmInstance.get(name);
    }

    public static synchronized void start() {
        for (Map.Entry<String, Dispatcher> entry : hmInstance.entrySet()) {
            Dispatcher dispatcher = entry.getValue();
            HashMap<Integer, TCPConnector> mapConnector = dispatcher.getMapConnector();
            for (Map.Entry<Integer, TCPConnector> entryCon : mapConnector.entrySet()) {
                TCPConnector connector = entryCon.getValue();
                connector.start();
            }
        }
    }

    public static synchronized void stop() {
        for (Map.Entry<String, Dispatcher> entry : hmInstance.entrySet()) {
            Dispatcher dispatcher = entry.getValue();
            HashMap<Integer, TCPConnector> mapConnector = dispatcher.getMapConnector();
            for (Map.Entry<Integer, TCPConnector> entryCon : mapConnector.entrySet()) {
                TCPConnector connector = entryCon.getValue();
                connector.stop();
            }
        }
    }
}

