/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.process;

import com.viettel.application.ussdapp.common.VasRequest;
import com.viettel.application.ussdapp.common.VasResponse;
import com.viettel.mmserver.base.ProcessThreadMX;
import com.viettel.ussdfw.log.ProcessVasgwLog;
import com.viettel.ussdfw.manager.AppManager;
import com.viettel.ussdfw.object.VasGwRecord;
import com.viettel.ussdfw.process.Dispatcher;
import java.util.Date;
import java.util.HashMap;

public abstract class ConnectorProcessThreadAbstract
extends ProcessThreadMX {
    private static long DEFAULT_DELAY_TIME = 0L;
    private static String DEFAULT_KEY_RETURN = "1";
    private String returnKey = null;
    private long delayTimeResp = 0L;
    private String name;
    private Dispatcher dispatcher;

    public ConnectorProcessThreadAbstract() {
        super("ConnectorProcessThreadAbstract");
    }

    public void config(String connectorName, int queueSize, String instanceName, HashMap<String, String> listFileConfig) throws Exception {
        this.logger.info((Object)("Config:" + instanceName));
        this.registerAgent(AppManager.appId + ":type=ConnectorProcessThreadAbstract,name=" + instanceName);
        this.name = instanceName;
        this.dispatcher = Dispatcher.getInstance(connectorName, queueSize, listFileConfig);
        this.setDelayTimeResp(DEFAULT_DELAY_TIME);
        this.setReturnKey(DEFAULT_KEY_RETURN);
        this.initBeforeStart();
    }

    public void start() {
        super.start();
        this.logger.info((Object)("Start ConnectorProcessThreadAbstract: " + this.name));
    }

    public void stop() {
        super.stop();
        this.logger.info((Object)("Stop ConnectorProcessThreadAbstract: " + this.name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void process() {
        VasRequest req = null;
        VasResponse rsp = null;
        VasGwRecord log = null;
        try {
            while ((req = this.dispatcher.getRequest()) == null || req.getId().equals("PING_RESP")) {
                Thread.sleep(100L);
            }
            this.logger.info((Object)("Queue size: " + this.dispatcher.getQueue().size()));
            this.logger.info((Object)(" get req msg from receive queue\n   request: " + req + "\n   params: " + req.getParams() + "\nsend response"));
            rsp = req.makeResponse();
            rsp.setConnectorId(req.getConnectorId());
            log = this.processRequest(req);
            rsp.setContent(log.getResponse());
            this.logger.info((Object)(" response: " + rsp));
            Thread.sleep(this.getDelayTimeResp());
            this.logger.info((Object)(" ----->sleep in " + this.getDelayTimeResp() + "s"));
        }
        catch (Exception e) {
            this.logger.error((Object)(" Has an error: " + e.getMessage()), (Throwable)e);
            rsp = req.makeResponse();
            rsp.setConnectorId(req.getConnectorId());
            rsp.setContent("ERROR");
            log = new VasGwRecord(req);
            log.setResponse("ERROR");
            log.setErrorCode(-1);
            log.setErrorDescription("System error");
            this.logger.info((Object)(" response: " + rsp));
        }
        try {
            this.dispatcher.sendResponse(rsp);
            this.logger.info((Object)" send sucess");
        }
        catch (Exception ex) {
            this.logger.error((Object)(" Has an error: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            log.setResponseTime(new Date());
            ProcessVasgwLog.enqueue(log);
        }
    }

    protected abstract void initBeforeStart() throws Exception;

    protected abstract VasGwRecord processRequest(VasRequest var1) throws Exception;

    public void setReturnKey(String returnKey) {
        this.returnKey = returnKey;
    }

    public String getReturnKey() {
        return this.returnKey;
    }

    public void setDelayTimeResp(long delayTimeResp) {
        this.delayTimeResp = delayTimeResp;
    }

    public long getDelayTimeResp() {
        return this.delayTimeResp;
    }
}

