/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.log;

import com.viettel.logging.LogWriter;
import com.viettel.mmserver.base.ProcessThreadMX;
import com.viettel.ussdfw.database.DbProcessorFW;
import com.viettel.ussdfw.manager.AppManager;
import com.viettel.ussdfw.object.VasGwRecord;
import java.util.ArrayList;
import utils.BlockQueue;

public class ProcessVasgwLog
extends ProcessThreadMX {
    private static BlockQueue queue = new BlockQueue(0, 5000);
    private boolean logToDb;
    private static LogWriter logVasGwWriter;
    private String dbId;
    private DbProcessorFW dbProcessor;

    public ProcessVasgwLog(String name, boolean logToDb, String dbPath, String dbId) {
        super(name);
        try {
            this.logToDb = logToDb;
            this.dbId = dbId;
            this.registerAgent(AppManager.appId + ":type=ProcessVasgwLog,name=" + name);
            if (logToDb) {
                this.dbProcessor = new DbProcessorFW(this.logger, dbPath);
            } else {
                logVasGwWriter = new LogWriter("../etc/log_writer.cfg", "/vasgw", "vasgwlog");
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"ERROR when init processLog", (Throwable)ex);
        }
    }

    public static synchronized void enqueue(VasGwRecord vasgw) {
        try {
            queue.enqueue((Object)vasgw);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    protected void process() {
        block8: {
            if (!queue.isEmpty()) {
                try {
                    if (this.logToDb) {
                        ArrayList<VasGwRecord> listVasgw = new ArrayList<VasGwRecord>();
                        for (int i = 0; i < 10 && !queue.isEmpty(); ++i) {
                            listVasgw.add((VasGwRecord)queue.dequeue());
                        }
                        this.dbProcessor.iInsertVasGwLog(listVasgw, this.dbId);
                        break block8;
                    }
                    VasGwRecord vasgw = null;
                    vasgw = (VasGwRecord)queue.dequeue();
                    logVasGwWriter.writeLn(vasgw.toLog());
                }
                catch (Exception ex) {
                    this.logger.error((Object)"error when process vasgw log", (Throwable)ex);
                }
            } else {
                try {
                    this.logger.debug((Object)"Khong co du lieu, sleep: 1s");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

