/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.exchangeService;

import com.viettel.common.ExchMsg;
import com.viettel.common.ViettelMsg;
import com.viettel.common.ViettelService;
import com.viettel.ussdfw.exchangeService.ExchangeChannel;
import com.viettel.ussdfw.exchangeService.ExchangeClientChannel;
import com.viettel.ussdfw.log.ProcessTransLog;
import com.viettel.ussdfw.object.TransactionLog;
import com.viettel.utility.PropertiesUtils;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ExchangeServiceFW {
    protected Logger logger;
    private String loggerLabel = "ExchangeServiceFW: ";
    private long timeSt;
    private long timeEx;
    protected StringBuffer br = new StringBuffer();
    protected ExchangeClientChannel exchangeClientChannel;
    private static HashMap loggerExchMap;
    private static long minTimeExch;
    private static long[] timesExchLevel;

    public ExchangeServiceFW(String name, String path) throws Exception {
        this.logger = Logger.getLogger((String)name);
        this.loadLogLevelWarnning(path);
        this.exchangeClientChannel = ExchangeClientChannel.getInstance(path);
    }

    public ExchangeServiceFW(Logger logger, String path) throws Exception {
        this.logger = logger;
        this.loadLogLevelWarnning(path);
        this.exchangeClientChannel = ExchangeClientChannel.getInstance(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViettelService send(ViettelService request, String msisdn) {
        ViettelService response = new ViettelService();
        TransactionLog log = new TransactionLog();
        log.setMsisdn(msisdn);
        log.setType(2);
        log.setRequest(request.toString());
        log.setCommand(request.getProcessCode());
        log.setErrorCode("000");
        try {
            this.setTimeSt(System.currentTimeMillis());
            log.setRequestTime(new Timestamp(this.timeSt));
            this.logger.info((Object)("REQUEST: " + request));
            ExchangeChannel channel = this.exchangeClientChannel.getChannel();
            log.setChannel(channel.getInfor());
            response = (ViettelService)channel.send((ViettelMsg)request);
            log.setResponse(response.toString().length() >= 4000 ? response.toString().substring(0, 3999) : response.toString());
            log.setResponseTime(new Timestamp(System.currentTimeMillis()));
            log.setErrorCode(response.getError());
        }
        catch (IOException ex) {
            this.logger.error((Object)"IOException when send to service => return error: 001", (Throwable)ex);
            response.setResponseCode("001");
            log.setResponseTime(new Timestamp(System.currentTimeMillis()));
            log.setErrorCode(response.getError());
        }
        catch (Exception ex) {
            this.logger.error((Object)"error when send to exchange => return error: 000 ", (Throwable)ex);
            response.setError("000");
            log.setResponseTime(new Timestamp(System.currentTimeMillis()));
            log.setErrorCode(response.getError());
        }
        finally {
            this.logger.info((Object)("RESPONSE: " + response));
            this.logTime("Time to " + request.getProcessCode());
            ProcessTransLog.enqueue(log);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchMsg send(ExchMsg request, String msisdn) {
        ExchMsg response = new ExchMsg();
        TransactionLog log = new TransactionLog();
        log.setMsisdn(msisdn);
        log.setType(1);
        log.setRequest(request.toString());
        log.setCommand(request.getCommand());
        log.setErrorCode("000");
        try {
            this.setTimeSt(System.currentTimeMillis());
            log.setRequestTime(new Timestamp(this.timeSt));
            this.logger.info((Object)("REQUEST: " + request));
            ExchangeChannel channel = this.exchangeClientChannel.getChannel();
            log.setChannel(channel.getInfor());
            response = (ExchMsg)channel.send((ViettelMsg)request);
            log.setResponse(response.toString().length() >= 4000 ? response.toString().substring(0, 3999) : response.toString());
            log.setResponseTime(new Timestamp(System.currentTimeMillis()));
            log.setErrorCode(response.getError());
        }
        catch (IOException ex) {
            this.logger.error((Object)"IOException when send to exchange => return error: 001 ", (Throwable)ex);
            response.setError("001");
            log.setResponseTime(new Timestamp(System.currentTimeMillis()));
            log.setErrorCode(response.getError());
        }
        catch (Exception ex) {
            this.logger.error((Object)"error when send to exchange => return error: 000 ", (Throwable)ex);
            response.setError("000");
            log.setResponseTime(new Timestamp(System.currentTimeMillis()));
            log.setErrorCode(response.getError());
        }
        finally {
            this.logger.info((Object)("RESPONSE: " + response));
            this.logTime("Time to " + request.getCommand());
            ProcessTransLog.enqueue(log);
        }
        return response;
    }

    public void setTimeSt(long timeSt) {
        this.timeSt = timeSt;
    }

    public void logTime(String strLog) {
        this.timeEx = System.currentTimeMillis() - this.timeSt;
        if (this.timeEx >= minTimeExch && loggerExchMap != null) {
            this.br.setLength(0);
            this.br.append(this.loggerLabel).append(this.getTimeLevelExch(this.timeEx)).append(": ").append(strLog).append(": ").append(this.timeEx).append(" ms");
            this.logger.warn((Object)this.br);
        } else {
            this.br.setLength(0);
            this.br.append(this.loggerLabel).append(strLog).append(": ").append(this.timeEx).append(" ms");
            this.logger.info((Object)this.br);
        }
    }

    private void loadLogLevelWarnning(String path) throws Exception {
        try {
            PropertiesUtils pros = new PropertiesUtils();
            pros.loadPropertiesEpt(path);
            String[] ocsTimes = pros.getProperty("EXCH_TIMES").split(",");
            String[] ocsKey = pros.getProperty("EXCH_MESSAGE_KEY").split(",");
            loggerExchMap = new HashMap();
            timesExchLevel = new long[ocsTimes.length];
            minTimeExch = Long.parseLong(ocsTimes[0].trim());
            for (int i = 0; i < ocsTimes.length; ++i) {
                ExchangeServiceFW.timesExchLevel[i] = Long.parseLong(ocsTimes[i].trim());
                loggerExchMap.put(i, ocsKey[i].trim());
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Loi lay thong tin EXCH_TIMES, EXCH_MESSAGE_KEY trong loglevel.conf", (Throwable)ex);
            loggerExchMap = null;
            throw ex;
        }
    }

    private String getTimeLevelExch(long times) {
        if (loggerExchMap != null) {
            String label;
            int key = Arrays.binarySearch(timesExchLevel, times);
            if (key < 0) {
                key = -key - 2;
            }
            return (label = (String)loggerExchMap.get(key)) == null ? "-" : label;
        }
        return null;
    }
}

