/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.database;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.viettel.ussdfw.object.ConnectionPoolObject;
import com.viettel.utility.PropertiesUtils;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ConnectionPoolManager {
    private static Logger logger = Logger.getLogger(ConnectionPoolManager.class);
    private static HashMap<String, ComboPooledDataSource> connectionMap = null;
    private static HashMap<String, String> connectionSchema = null;

    public static void loadConfig(String dbConfigXml) throws Exception {
        if (connectionMap == null) {
            connectionMap = new HashMap();
            connectionSchema = new HashMap();
            try {
                PropertiesUtils proUtils = new PropertiesUtils();
                proUtils.loadPropertiesEpt(dbConfigXml);
                StringBuilder build = new StringBuilder();
                String[] proStr = proUtils.getProperties();
                for (int i = 0; i < proStr.length; ++i) {
                    build.append(proStr[i]);
                }
                InputSource is = new InputSource(new StringReader(build.toString()));
                DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = df.newDocumentBuilder();
                Document dc = db.parse(is);
                Element root = dc.getDocumentElement();
                HashMap connectors = new HashMap();
                boolean index = false;
                NodeList list = root.getElementsByTagName("named-config");
                if (list.getLength() < 1) {
                    throw new Exception("No named-config");
                }
                for (int i = 0; i < list.getLength(); ++i) {
                    Element ele = (Element)list.item(i);
                    String dbName = ele.getAttribute("name");
                    NodeList listProperty = ele.getElementsByTagName("property");
                    if (listProperty.getLength() < 1) {
                        throw new Exception("No property");
                    }
                    Properties pro = new Properties();
                    for (int j = 0; j < listProperty.getLength(); ++j) {
                        Element elePro = (Element)listProperty.item(j);
                        String name = elePro.getAttribute("name");
                        String value = elePro.getTextContent();
                        pro.setProperty(name, value);
                    }
                    ConnectionPoolObject obj = new ConnectionPoolObject(pro);
                    obj.setId(dbName);
                    try {
                        connectionMap.put(dbName, obj.createPoolConnection());
                        connectionSchema.put(dbName, pro.getProperty("schema", ""));
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("==> ERROR WHEN INIT DATABASE ID=" + dbName), (Throwable)e);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"==> ERROR INIT DATABASE LIST", (Throwable)ex);
                throw ex;
            }
        }
    }

    public static void reLoadConfig(String dbConfigXml) throws Exception {
        connectionMap = new HashMap();
        connectionSchema = new HashMap();
        try {
            PropertiesUtils proUtils = new PropertiesUtils();
            proUtils.loadPropertiesEpt(dbConfigXml);
            StringBuilder build = new StringBuilder();
            String[] proStr = proUtils.getProperties();
            for (int i = 0; i < proStr.length; ++i) {
                build.append(proStr[i]);
            }
            InputSource is = new InputSource(new StringReader(build.toString()));
            DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = df.newDocumentBuilder();
            Document dc = db.parse(is);
            Element root = dc.getDocumentElement();
            HashMap connectors = new HashMap();
            boolean index = false;
            NodeList list = root.getElementsByTagName("named-config");
            if (list.getLength() < 1) {
                throw new Exception("No named-config");
            }
            for (int i = 0; i < list.getLength(); ++i) {
                Element ele = (Element)list.item(i);
                String dbName = ele.getAttribute("name");
                NodeList listProperty = ele.getElementsByTagName("property");
                if (listProperty.getLength() < 1) {
                    throw new Exception("No property");
                }
                Properties pro = new Properties();
                for (int j = 0; j < listProperty.getLength(); ++j) {
                    Element elePro = (Element)listProperty.item(j);
                    String name = elePro.getAttribute("name");
                    String value = elePro.getTextContent();
                    pro.setProperty(name, value);
                }
                ConnectionPoolObject obj = new ConnectionPoolObject(pro);
                obj.setId(dbName);
                try {
                    connectionMap.put(dbName, obj.createPoolConnection());
                    connectionSchema.put(dbName, pro.getProperty("schema", ""));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("==> ERROR WHEN INIT DATABASE ID=" + dbName), (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"==> ERROR INIT DATABASE LIST", (Throwable)ex);
            throw ex;
        }
    }

    public static synchronized Connection getConnection(String id) {
        Connection conn = null;
        try {
            if (connectionMap.containsKey(id)) {
                conn = connectionMap.get(id).getConnection();
            } else {
                logger.warn((Object)("PooledDataSource don't have ID: " + id));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)("Can't connect DB, with ID: " + id), (Throwable)ex);
        }
        return conn;
    }

    public static HashMap<String, ComboPooledDataSource> getConnectionMap() {
        return connectionMap;
    }

    public static void setConnectionMap(HashMap<String, ComboPooledDataSource> connectionMap) {
        ConnectionPoolManager.connectionMap = connectionMap;
    }

    public static synchronized String getSchema(String id) {
        String schema = null;
        if (connectionSchema.containsKey(id)) {
            schema = connectionSchema.get(id);
        } else {
            logger.warn((Object)("PooledDataSource don't have ID: " + id));
        }
        return schema;
    }
}

