/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.utility;

import com.viettel.common.shared.ConverterUtil;
import com.viettel.utility.DecryptInputUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.crypto.SecretKey;
import utils.Config;

public class PropertiesUtils {
    private static int MAX_LENGTH = 10000;
    private String[] properties;

    public void loadProperties(String fileName) throws IOException, Exception {
        String contentDeCrypted;
        String contentEnCrypted = null;
        PropertiesUtils pro = new PropertiesUtils();
        File encryptModeFile = new File(Config.getConfigDir() + File.separator + "encrypt.conf");
        boolean isEnCryptFile = true;
        if (encryptModeFile.exists()) {
            FileReader encryptedModeReader = new FileReader(encryptModeFile);
            pro.loadProperties(encryptedModeReader, false);
            isEnCryptFile = Boolean.valueOf(pro.getProperty("IsEnCrypted", "true"));
            encryptedModeReader.close();
            pro.clearProperties();
        }
        if (isEnCryptFile) {
            File aesKeyFile = new File(Config.getConfigDir() + File.separator + "aeskey.sec");
            FileReader encryptedModeReader = new FileReader(aesKeyFile);
            pro.loadProperties(encryptedModeReader, false);
            String aesKey = pro.getProperty("key");
            encryptedModeReader.close();
            pro.clearProperties();
            SecretKey securKey = ConverterUtil.createSecretKey((String)aesKey);
            contentEnCrypted = DecryptInputUtils.decrypt(fileName);
            contentDeCrypted = ConverterUtil.aesDecrypt((SecretKey)securKey, (String)contentEnCrypted);
        } else {
            File fy = new File(fileName);
            int lengFile = (int)fy.length();
            FileReader reader = new FileReader(fileName);
            char[] buffer = new char[lengFile];
            int length = reader.read(buffer);
            char[] realBuffer = new char[length];
            System.arraycopy(buffer, 0, realBuffer, 0, length);
            contentDeCrypted = new String(realBuffer);
            ((Reader)reader).close();
        }
        this.properties = contentDeCrypted.split("\n");
    }

    public void loadPropertiesEpt(String filePath) throws IOException, Exception {
        String contentDeCrypted;
        String contentEnCrypted = null;
        PropertiesUtils pro = new PropertiesUtils();
        File f = new File(filePath);
        File encryptModeFile = new File(f.getParent() + File.separator + f.getName() + ".ept");
        boolean isEnCryptFile = true;
        if (encryptModeFile.exists()) {
            FileReader encryptedModeReader = new FileReader(encryptModeFile);
            pro.loadProperties(encryptedModeReader, false);
            isEnCryptFile = Boolean.valueOf(pro.getProperty("IsEnCrypted", "true"));
            encryptedModeReader.close();
            pro.clearProperties();
        }
        if (isEnCryptFile) {
            File aesKeyFile = new File(Config.getConfigDir() + File.separator + "aeskey.sec");
            FileReader encryptedModeReader = new FileReader(aesKeyFile);
            pro.loadProperties(encryptedModeReader, false);
            String aesKey = pro.getProperty("key");
            encryptedModeReader.close();
            pro.clearProperties();
            SecretKey securKey = ConverterUtil.createSecretKey((String)aesKey);
            contentEnCrypted = DecryptInputUtils.decrypt(filePath);
            contentDeCrypted = ConverterUtil.aesDecrypt((SecretKey)securKey, (String)contentEnCrypted);
        } else {
            File fy = new File(filePath);
            int lengFile = (int)fy.length();
            FileReader reader = new FileReader(filePath);
            char[] buffer = new char[lengFile];
            int length = reader.read(buffer);
            char[] realBuffer = new char[length];
            System.arraycopy(buffer, 0, realBuffer, 0, length);
            contentDeCrypted = new String(realBuffer);
            ((Reader)reader).close();
        }
        this.properties = contentDeCrypted.split("\n");
    }

    public void loadProperties(String fileName, String fileEncrypt) throws IOException, Exception {
        String contentDeCrypted;
        String contentEnCrypted = null;
        PropertiesUtils pro = new PropertiesUtils();
        File encryptModeFile = new File(fileEncrypt);
        boolean isEnCryptFile = true;
        if (encryptModeFile.exists()) {
            FileReader encryptedModeReader = new FileReader(encryptModeFile);
            pro.loadProperties(encryptedModeReader, false);
            isEnCryptFile = Boolean.valueOf(pro.getProperty("IsEnCrypted", "true"));
            encryptedModeReader.close();
            pro.clearProperties();
        }
        if (isEnCryptFile) {
            File aesKeyFile = new File(Config.getConfigDir() + File.separator + "aeskey.sec");
            FileReader encryptedModeReader = new FileReader(aesKeyFile);
            pro.loadProperties(encryptedModeReader, false);
            String aesKey = pro.getProperty("key");
            encryptedModeReader.close();
            pro.clearProperties();
            SecretKey securKey = ConverterUtil.createSecretKey((String)aesKey);
            contentEnCrypted = DecryptInputUtils.decrypt(fileName);
            contentDeCrypted = ConverterUtil.aesDecrypt((SecretKey)securKey, (String)contentEnCrypted);
        } else {
            File fy = new File(fileName);
            int lengFile = (int)fy.length();
            FileReader reader = new FileReader(fileName);
            char[] buffer = new char[lengFile];
            int length = reader.read(buffer);
            char[] realBuffer = new char[length];
            System.arraycopy(buffer, 0, realBuffer, 0, length);
            contentDeCrypted = new String(realBuffer);
            ((Reader)reader).close();
        }
        this.properties = contentDeCrypted.split("\n");
    }

    public void loadProperties(String fileName, boolean isEnCryptFile) throws IOException, Exception {
        String contentDeCrypted;
        String contentEnCrypted = null;
        if (isEnCryptFile) {
            PropertiesUtils pro = new PropertiesUtils();
            File aesKeyFile = new File(Config.getConfigDir() + File.separator + "aeskey.sec");
            FileReader encryptedModeReader = new FileReader(aesKeyFile);
            pro.loadProperties(encryptedModeReader, false);
            String aesKey = pro.getProperty("key");
            encryptedModeReader.close();
            pro.clearProperties();
            SecretKey securKey = ConverterUtil.createSecretKey((String)aesKey);
            contentEnCrypted = DecryptInputUtils.decrypt(fileName);
            contentDeCrypted = ConverterUtil.aesDecrypt((SecretKey)securKey, (String)contentEnCrypted);
        } else {
            FileReader reader = new FileReader(fileName);
            File fy = new File(fileName);
            int lengFile = (int)fy.length();
            char[] buffer = new char[lengFile];
            int length = reader.read(buffer);
            if (length <= 0) {
                return;
            }
            char[] realBuffer = new char[length];
            System.arraycopy(buffer, 0, realBuffer, 0, length);
            contentDeCrypted = new String(realBuffer);
            ((Reader)reader).close();
        }
        this.properties = contentDeCrypted.split("\n");
    }

    public void loadProperties(Reader reader) throws IOException, Exception {
        String contentDeCrypted;
        char[] buffer = new char[MAX_LENGTH];
        int length = reader.read(buffer);
        char[] realBuffer = new char[length];
        System.arraycopy(buffer, 0, realBuffer, 0, length);
        String contentEnCrypted = new String(realBuffer);
        PropertiesUtils pro = new PropertiesUtils();
        File encryptModeFile = new File("../etc/encrypt.conf");
        boolean isEnCryptFile = true;
        if (encryptModeFile.exists()) {
            FileReader encryptedModeReader = new FileReader("../etc/encrypt.conf");
            pro.loadProperties(encryptedModeReader, false);
            isEnCryptFile = Boolean.valueOf(pro.getProperty("IsEnCrypted", "true"));
            encryptedModeReader.close();
            pro.clearProperties();
        }
        if (isEnCryptFile) {
            File aesKeyFile = new File(Config.getConfigDir() + File.separator + "aeskey.sec");
            FileReader encryptedModeReader = new FileReader(aesKeyFile);
            pro.loadProperties(encryptedModeReader, false);
            String aesKey = pro.getProperty("key");
            encryptedModeReader.close();
            pro.clearProperties();
            SecretKey securKey = ConverterUtil.createSecretKey((String)aesKey);
            contentDeCrypted = ConverterUtil.aesDecrypt((SecretKey)securKey, (String)contentEnCrypted);
        } else {
            contentDeCrypted = contentEnCrypted;
        }
        this.properties = contentDeCrypted.split("\n");
    }

    public void loadProperties(InputStream inputStream) throws IOException, Exception {
        String contentDeCrypted;
        char[] buffer = new char[MAX_LENGTH];
        InputStreamReader reader = new InputStreamReader(inputStream);
        int length = reader.read(buffer);
        char[] realBuffer = new char[length];
        System.arraycopy(buffer, 0, realBuffer, 0, length);
        String contentEnCrypted = new String(realBuffer);
        PropertiesUtils pro = new PropertiesUtils();
        File encryptModeFile = new File("../etc/encrypt.conf");
        boolean isEnCryptFile = true;
        if (encryptModeFile.exists()) {
            FileReader encryptedModeReader = new FileReader("../etc/encrypt.conf");
            pro.loadProperties(encryptedModeReader, false);
            isEnCryptFile = Boolean.valueOf(pro.getProperty("IsEnCrypted", "true"));
            encryptedModeReader.close();
            pro.clearProperties();
        }
        if (isEnCryptFile) {
            File aesKeyFile = new File(Config.getConfigDir() + File.separator + "aeskey.sec");
            FileReader encryptedModeReader = new FileReader(aesKeyFile);
            pro.loadProperties(encryptedModeReader, false);
            String aesKey = pro.getProperty("key");
            encryptedModeReader.close();
            pro.clearProperties();
            SecretKey securKey = ConverterUtil.createSecretKey((String)aesKey);
            contentDeCrypted = ConverterUtil.aesDecrypt((SecretKey)securKey, (String)contentEnCrypted);
        } else {
            contentDeCrypted = contentEnCrypted;
        }
        this.properties = contentDeCrypted.split("\n");
    }

    public void loadProperties(Reader reader, boolean isEnCryptFile) throws IOException, Exception {
        String contentDeCrypted;
        char[] buffer = new char[MAX_LENGTH];
        int length = reader.read(buffer);
        char[] realBuffer = new char[length];
        System.arraycopy(buffer, 0, realBuffer, 0, length);
        String contentEnCrypted = new String(realBuffer);
        if (isEnCryptFile) {
            PropertiesUtils pro = new PropertiesUtils();
            File aesKeyFile = new File(Config.getConfigDir() + File.separator + "aeskey.sec");
            FileReader encryptedModeReader = new FileReader(aesKeyFile);
            pro.loadProperties(encryptedModeReader, false);
            String aesKey = pro.getProperty("key");
            encryptedModeReader.close();
            pro.clearProperties();
            SecretKey securKey = ConverterUtil.createSecretKey((String)aesKey);
            contentDeCrypted = ConverterUtil.aesDecrypt((SecretKey)securKey, (String)contentEnCrypted);
        } else {
            contentDeCrypted = contentEnCrypted;
        }
        this.properties = contentDeCrypted.split("\n");
    }

    public void loadProperties(InputStream inputStream, boolean isEnCryptFile) throws IOException, Exception {
        String contentDeCrypted;
        char[] buffer = new char[MAX_LENGTH];
        InputStreamReader reader = new InputStreamReader(inputStream);
        int length = reader.read(buffer);
        char[] realBuffer = new char[length];
        System.arraycopy(buffer, 0, realBuffer, 0, length);
        String contentEnCrypted = new String(realBuffer);
        if (isEnCryptFile) {
            PropertiesUtils pro = new PropertiesUtils();
            File aesKeyFile = new File(Config.getConfigDir() + File.separator + "aeskey.sec");
            FileReader encryptedModeReader = new FileReader(aesKeyFile);
            pro.loadProperties(encryptedModeReader, false);
            String aesKey = pro.getProperty("key");
            encryptedModeReader.close();
            pro.clearProperties();
            SecretKey securKey = ConverterUtil.createSecretKey((String)aesKey);
            contentDeCrypted = ConverterUtil.aesDecrypt((SecretKey)securKey, (String)contentEnCrypted);
        } else {
            contentDeCrypted = contentEnCrypted;
        }
        this.properties = contentDeCrypted.split("\n");
    }

    public static String getProperty(String[] properties, String propertyName, String defaultValue) {
        String propertyValue = null;
        for (int i = 0; i < properties.length; ++i) {
            String string = properties[i];
            if (string == null || !(string = string.trim()).matches(propertyName + "((\\s+=)|(=)).+")) continue;
            propertyValue = string.split(propertyName + "((\\s+=)|(=))")[1].trim();
        }
        if (propertyValue == null) {
            propertyValue = defaultValue;
        }
        return propertyValue;
    }

    public static String getProperty(String[] properties, String propertyName) {
        String propertyValue = null;
        for (int i = 0; i < properties.length; ++i) {
            String string = properties[i];
            if (string == null || !(string = string.trim()).matches(propertyName + "((\\s+=)|(=)).+")) continue;
            propertyValue = string.split(propertyName + "((\\s+=)|(=))")[1].trim();
        }
        return propertyValue;
    }

    public String getProperty(String propertyName, String defaultValue) {
        String propertyValue = null;
        if (this.properties == null) {
            propertyValue = defaultValue;
        } else {
            for (int i = 0; i < this.properties.length; ++i) {
                String string = this.properties[i];
                if (string == null || !(string = string.trim()).matches(propertyName + "((\\s+=)|(=)).+")) continue;
                propertyValue = string.split(propertyName + "((\\s+=)|(=))")[1].trim();
            }
        }
        if (propertyValue == null) {
            propertyValue = defaultValue;
        }
        return propertyValue;
    }

    public String getPropertyUppered(String propertyName, String defaultValue) {
        String propertyValue = null;
        if (this.properties == null) {
            propertyValue = defaultValue;
        } else {
            for (int i = 0; i < this.properties.length; ++i) {
                String string = this.properties[i];
                if (string == null) continue;
                string = string.toUpperCase();
                if (!(string = string.trim()).matches(propertyName.toUpperCase() + "((\\s+=)|(=)).+")) continue;
                propertyValue = string.split(propertyName.toUpperCase() + "((\\s+=)|(=))")[1].trim();
            }
        }
        if (propertyValue == null) {
            propertyValue = defaultValue;
        }
        return propertyValue;
    }

    public String getProperty(String propertyName) {
        String propertyValue = null;
        for (int i = 0; i < this.properties.length; ++i) {
            String string = this.properties[i];
            if (string == null || !(string = string.trim()).matches(propertyName + "((\\s+=)|(=)).+")) continue;
            propertyValue = string.split(propertyName + "((\\s+=)|(=))")[1].trim();
        }
        return propertyValue;
    }

    public String getPropertyUppered(String propertyName) {
        String propertyValue = null;
        for (int i = 0; i < this.properties.length; ++i) {
            String string = this.properties[i];
            if (string == null) continue;
            string = string.toUpperCase();
            if (!(string = string.trim()).matches(propertyName.toUpperCase() + "((\\s+=)|(=)).+")) continue;
            propertyValue = string.split(propertyName.toUpperCase() + "((\\s+=)|(=))")[1].trim();
        }
        return propertyValue;
    }

    public void clearProperties() {
        this.properties = null;
    }

    public static int getMAX_LENGTH() {
        return MAX_LENGTH;
    }

    public static void setMAX_LENGTH(int MAX_LENGTH) {
        PropertiesUtils.MAX_LENGTH = MAX_LENGTH;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void setProperties(String[] properties) {
        this.properties = properties;
    }
}

