/*
 * Decompiled with CFR 0.152.
 */
package viettel.passport.client;

import java.util.ArrayList;
import org.w3c.dom.Element;
import viettel.passport.util.XMLUtil;

public class ObjectToken
implements Comparable<ObjectToken> {
    private ArrayList<ObjectToken> childObjects = new ArrayList();
    private Long ord;
    private long parentId;
    private long status;
    private long objectId;
    private long objectType;
    private String description;
    private String objectName;
    private String objectUrl;
    public static final String MODULE_TYPE = "M";
    public static final String COMPONENT_TYPE = "C";

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectType() {
        if (this.objectType == 0L) {
            return MODULE_TYPE;
        }
        return COMPONENT_TYPE;
    }

    public void setObjectType(long objectType) {
        this.objectType = objectType;
    }

    public String getObjectUrl() {
        return this.objectUrl;
    }

    public void setObjectUrl(String objectUrl) {
        this.objectUrl = objectUrl;
    }

    public Long getOrd() {
        return this.ord;
    }

    public void setOrd(Long ord) {
        this.ord = ord;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public long getStatus() {
        return this.status;
    }

    public void setStatus(long status) {
        this.status = status;
    }

    public ArrayList<ObjectToken> getChildObjects() {
        return this.childObjects;
    }

    public void setChildObjects(ArrayList<ObjectToken> childObjects) {
        this.childObjects = childObjects;
    }

    @Override
    public int compareTo(ObjectToken o) {
        return this.ord.compareTo(o.ord);
    }

    public static ArrayList<ObjectToken> findFirstLevelMenus(ArrayList<ObjectToken> listObjects) {
        ArrayList<ObjectToken> list = new ArrayList<ObjectToken>();
        for (ObjectToken item : listObjects) {
            ObjectToken mt = item;
            if (mt.getParentId() > 0L) continue;
            list.add(mt);
        }
        return list;
    }

    public static ObjectToken getMenuToken(Element menuEle) {
        ObjectToken mt = new ObjectToken();
        mt.setObjectId(XMLUtil.getLongValue(menuEle, "OBJECT_ID"));
        mt.setParentId(XMLUtil.getLongValue(menuEle, "PARENT_ID"));
        mt.setStatus(XMLUtil.getLongValue(menuEle, "STATUS"));
        mt.setOrd(XMLUtil.getLongValue(menuEle, "ORD"));
        mt.setObjectUrl(XMLUtil.getTextValue(menuEle, "OBJECT_URL"));
        mt.setObjectName(XMLUtil.getTextValue(menuEle, "OBJECT_NAME"));
        mt.setDescription(XMLUtil.getTextValue(menuEle, "DESCRIPTION"));
        mt.setObjectType(XMLUtil.getLongValue(menuEle, "OBJECT_TYPE_ID"));
        return mt;
    }
}

