/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.security;

import java.security.AlgorithmParameters;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AppSecurity {
    public static SecretKey key = null;
    public static AlgorithmParameters desparam;
    public static final String Hex = "0123456789ABCDEF";
    public static String mstrDefaultKey;
    public static final byte[] Hex2Byte;

    public static byte[] encrypt0(byte[] bInputData) throws Exception {
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding", "SunJCE");
        cipher.init(1, (Key)key, desparam);
        return cipher.doFinal(AppSecurity.fillBlock(bInputData));
    }

    public static byte[] encrypt0(String strmsg) throws Exception {
        byte[] data = AppSecurity.fillBlock(strmsg);
        return AppSecurity.encrypt0(data);
    }

    public static String encrypt(String strmsg) throws Exception {
        byte[] data = AppSecurity.fillBlock(strmsg);
        return AppSecurity.getHexDump(AppSecurity.encrypt0(data));
    }

    private static byte[] fillBlock(String strmsg) {
        byte[] dataTemp = strmsg.getBytes();
        return AppSecurity.fillBlock(dataTemp);
    }

    private static byte[] fillBlock(byte[] dataTemp) {
        int i = dataTemp.length % 8;
        int length = i != 0 ? dataTemp.length - i + 8 : dataTemp.length;
        byte[] data = new byte[length];
        if (i != 0) {
            for (int j = 0; j < length; ++j) {
                data[j] = j < dataTemp.length ? dataTemp[j] : -1;
            }
        } else {
            data = dataTemp;
        }
        return data;
    }

    public static byte[] decrypt0(byte[] inpBytes) throws Exception {
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding", "SunJCE");
        cipher.init(2, (Key)key, desparam);
        return cipher.doFinal(inpBytes);
    }

    public static String decrypt(byte[] inpBytes) throws Exception {
        byte[] result = AppSecurity.decrypt0(inpBytes);
        String strHex = AppSecurity.getHexDump(result);
        strHex = strHex.toLowerCase();
        strHex = strHex.replaceAll("ff", "");
        return new String(AppSecurity.convertHexToByte(strHex));
    }

    public static String getHexDump(byte[] data) {
        String dump = "";
        try {
            int dataLen = data.length;
            for (int i = 0; i < dataLen; ++i) {
                dump = dump + Character.forDigit(data[i] >> 4 & 0xF, 16);
                dump = dump + Character.forDigit(data[i] & 0xF, 16);
            }
        }
        catch (Throwable t) {
            dump = "Throwable caught when dumping = " + t;
        }
        return dump;
    }

    public static byte[] convertHexToByte(String strHex) {
        String strTemp = "";
        strTemp = strHex.toUpperCase();
        if (strTemp.length() % 2 != 0) {
            // empty if block
        }
        int length = strTemp.length() / 2;
        byte[] keySec = new byte[length];
        for (int i = 0; i < length; ++i) {
            char ch0 = strTemp.charAt(2 * i);
            char ch1 = strTemp.charAt(2 * i + 1);
            int loByte = Hex.indexOf(ch0);
            int hiByte = Hex.indexOf(ch1);
            byte lo = Hex2Byte[loByte];
            byte hi = Hex2Byte[hiByte];
            Byte byelo = new Byte(lo);
            Byte byehi = new Byte(hi);
            int inlo = byelo.intValue();
            int inhi = byehi.intValue();
            int value = inlo * 16 + inhi;
            keySec[i] = (byte)value;
        }
        return keySec;
    }

    public static SecretKey createKey(String key) {
        byte[] keyData = AppSecurity.convertHexToByte(key);
        SecretKeySpec keyReturn = new SecretKeySpec(keyData, "DESede");
        return keyReturn;
    }

    public static String createRadomKey() {
        String strKey = "";
        for (int i = 0; i < 48; ++i) {
            double dbkey = Math.random() * 1000.0;
            int intkey = (int)Math.round(dbkey);
            strKey = strKey + Hex.charAt(intkey %= 16);
        }
        return strKey;
    }

    public static String createCashTransferCommand(String iccid, String mpin, String target, int amount, String baseID) throws Exception {
        String rt = "";
        String message = "CASHTRANSFER " + mpin + " " + target + " " + amount;
        String encryptedData = AppSecurity.encrypt(iccid, message);
        char c = (char)encryptedData.length();
        byte[] b = new byte[]{(byte)c};
        String strLen = AppSecurity.getHexDump(b);
        rt = iccid + " " + strLen + "/" + encryptedData + "/" + baseID;
        return rt;
    }

    public static String createReLoadCommand(String iccid, String mpin, String target, int amount, String baseID, String language, String counter) throws Exception {
        String rt = "";
        String message = "RELOAD " + mpin + " " + target + " " + amount;
        String encryptedData = AppSecurity.encrypt(iccid, message);
        char c = (char)encryptedData.length();
        byte[] b = new byte[]{(byte)c};
        String strLen = AppSecurity.getHexDump(b);
        rt = iccid + " " + strLen + "/" + encryptedData + "/" + baseID;
        if (language != null && !language.equals("")) {
            rt = rt + " " + language;
        }
        if (counter != null && !counter.equals("")) {
            rt = rt + " " + counter;
        }
        return rt.trim();
    }

    public static String createReLoadToday(String iccid, String mpin, String baseID, String counter) throws Exception {
        String rt = "";
        String message = "RECHSOLD " + mpin + " TODAY";
        String encryptedData = AppSecurity.encrypt(iccid, message);
        char c = (char)encryptedData.length();
        byte[] b = new byte[]{(byte)c};
        String strLen = AppSecurity.getHexDump(b);
        rt = iccid + " " + strLen + "/" + encryptedData + "/" + baseID;
        if (counter != null && !counter.equals("")) {
            rt = rt + " " + counter;
        }
        return rt.trim();
    }

    public static String getIccIDKey(String iccid) {
        String strReturn = "";
        for (int i = 0; i < iccid.length(); ++i) {
            strReturn = strReturn + "3";
            strReturn = strReturn + iccid.substring(i, i + 1);
        }
        while (strReturn.length() < 48) {
            strReturn = strReturn + "f";
        }
        return strReturn;
    }

    public static String encrypt(String iccid, String message) throws Exception {
        iccid = AppSecurity.getIccIDKey(iccid);
        key = AppSecurity.createKey(iccid);
        String strResult = AppSecurity.encrypt(message);
        return strResult;
    }

    private static byte[] createIccidKey(byte[] iccid) {
        if (iccid == null) {
            return null;
        }
        byte[] keyIccid = new byte[24];
        int pos = 0;
        for (int i = 0; i < iccid.length && pos < 24; ++i) {
            keyIccid[pos++] = iccid[i];
        }
        while (pos < 24) {
            keyIccid[pos++] = -1;
        }
        return keyIccid;
    }

    public static SecretKey createKey(byte[] iccidKey) {
        if (iccidKey == null) {
            return null;
        }
        SecretKeySpec keyReturn = new SecretKeySpec(iccidKey, "DESede");
        return keyReturn;
    }

    public static byte[] decrypt0(byte[] inpBytes, SecretKey key1) throws Exception {
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding", "SunJCE");
        cipher.init(2, (Key)key1, desparam);
        return cipher.doFinal(inpBytes);
    }

    public static String decrypt(byte[] iccid, byte[] encryptdata) throws Exception {
        int pos;
        if (iccid == null || encryptdata == null) {
            return null;
        }
        if (encryptdata.length == 0) {
            return "";
        }
        byte[] iccidKey = AppSecurity.createIccidKey(iccid);
        if (iccidKey == null) {
            return null;
        }
        SecretKey key1 = AppSecurity.createKey(iccidKey);
        if (key1 == null) {
            return null;
        }
        byte[] out = AppSecurity.decrypt0(encryptdata, key1);
        if (out == null) {
            return null;
        }
        for (pos = out.length - 1; pos >= 0 && out[pos] == -1; --pos) {
        }
        byte[] out1 = new byte[pos + 1];
        System.arraycopy(out, 0, out1, 0, pos + 1);
        return new String(out1);
    }

    public static String decrypt(String iccid, String message) throws Exception {
        iccid = AppSecurity.getIccIDKey(iccid);
        key = AppSecurity.createKey(iccid);
        byte[] data = AppSecurity.convertHexToByte(message);
        String strResult = AppSecurity.decrypt(data);
        return strResult;
    }

    public static void main(String[] args) {
        try {
            String strmsg = "DA;123;123;123;123;";
            byte[] data = AppSecurity.fillBlock(strmsg);
            System.out.println(AppSecurity.getHexDump(data));
            byte[] b = AppSecurity.encrypt0(data);
            System.out.println(AppSecurity.getHexDump(b));
            System.out.println(new String(b));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        Hex2Byte = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        desparam = null;
        mstrDefaultKey = "101010101010101010101010101010101010101010101010";
        try {
            key = AppSecurity.createKey(mstrDefaultKey);
            byte[] myIv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            IvParameterSpec desparamspec = new IvParameterSpec(myIv);
            desparam = AlgorithmParameters.getInstance("TripleDES");
            desparam.init(desparamspec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

