/*
 * Decompiled with CFR 0.152.
 */
package loader;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import loader.ApplicationLoaderMX;
import loader.ReloadingClassLoader;

public class ApplicationLoader
extends ApplicationLoaderMX {
    private static final String DIR = "../module/";
    private String dir;
    private Map<String, ReloadingClassLoader> classLoaders = new HashMap<String, ReloadingClassLoader>();

    public ApplicationLoader() {
        this(DIR);
    }

    public ApplicationLoader(String dir) {
        this.dir = dir;
        try {
            String mbeansName = "loader:type=Loaders";
            this.logger.info((Object)("register MBean:" + mbeansName));
            this.registerAgent(mbeansName);
        }
        catch (MalformedObjectNameException ex) {
            this.logger.error((Object)("register MBeanServer exception:" + ex));
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (InstanceAlreadyExistsException ex) {
            this.logger.error((Object)("register MBeanServer exception:" + ex));
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (MBeanRegistrationException ex) {
            this.logger.error((Object)("register MBeanServer exception:" + ex));
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (NotCompliantMBeanException ex) {
            this.logger.error((Object)("register MBeanServer exception:" + ex));
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void destroy() {
        try {
            String mbeansName = "loader:type=Loaders";
            this.logger.info((Object)("register MBean:" + mbeansName));
            this.unregisterAgent(mbeansName);
        }
        catch (MalformedObjectNameException ex) {
            this.logger.error((Object)("register MBeanServer exception:" + ex));
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (InstanceNotFoundException ex) {
            this.logger.error((Object)("register MBeanServer exception:" + ex));
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (MBeanRegistrationException ex) {
            this.logger.error((Object)("register MBeanServer exception:" + ex));
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public ReloadingClassLoader addLoader(String appId) {
        if (this.classLoaders.containsKey(appId)) {
            this.logger.info((Object)("loadder [" + appId + "] already added"));
            return this.classLoaders.get(appId);
        }
        String appDir = this.dir + appId;
        ReloadingClassLoader loader = (ReloadingClassLoader)AccessController.doPrivileged(new LoaderPrivilegedAction(appDir));
        this.classLoaders.put(appId, loader);
        try {
            String mbeansName = "loader:type=Loaders,name=" + appId;
            this.logger.info((Object)("register MBean:" + mbeansName));
            loader.registerAgent(mbeansName);
        }
        catch (MalformedObjectNameException ex) {
            this.logger.error((Object)"register MBeanServer exception.", (Throwable)ex);
        }
        catch (InstanceAlreadyExistsException ex) {
            this.logger.error((Object)"register MBeanServer exception.", (Throwable)ex);
        }
        catch (MBeanRegistrationException ex) {
            this.logger.error((Object)"register MBeanServer exception.", (Throwable)ex);
        }
        catch (NotCompliantMBeanException ex) {
            this.logger.error((Object)"register MBeanServer exception.", (Throwable)ex);
        }
        return loader;
    }

    public void removeLoader(String appId) {
        if (this.classLoaders.containsKey(appId)) {
            ReloadingClassLoader loader = this.classLoaders.get(appId);
            try {
                String mbeansName = "loader:type=Loaders,name=" + appId;
                this.logger.info((Object)("unregister MBean:" + mbeansName));
                loader.unregisterAgent(mbeansName);
            }
            catch (MalformedObjectNameException ex) {
                this.logger.error((Object)("register MBeanServer exception:" + ex));
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (InstanceNotFoundException ex) {
                this.logger.error((Object)("register MBeanServer exception:" + ex));
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (MBeanRegistrationException ex) {
                this.logger.error((Object)("register MBeanServer exception:" + ex));
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            this.classLoaders.remove(appId);
        }
    }

    public ReloadingClassLoader getLoader(String appId) {
        if (this.classLoaders.containsKey(appId)) {
            return this.classLoaders.get(appId);
        }
        return this.addLoader(appId);
    }

    public void updateLoader() {
        for (ReloadingClassLoader loader : this.classLoaders.values()) {
            loader.updateClassPath();
        }
    }

    public String getInfor() {
        StringBuffer buff = new StringBuffer();
        buff.append("Loaders=" + this.classLoaders.size());
        buff.append("\r\nDirectory=" + this.dir);
        return buff.toString();
    }

    static class LoaderPrivilegedAction
    implements PrivilegedAction {
        private String appDir;

        public LoaderPrivilegedAction(String appDir) {
            this.appDir = appDir;
        }

        public Object run() {
            return new ReloadingClassLoader(ClassLoader.getSystemClassLoader(), this.appDir);
        }
    }
}

