/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.base;

import com.viettel.mmserver.agent.MMbeanServer;
import com.viettel.mmserver.base.Log;
import com.viettel.mmserver.base.StatusCollectorMBean;
import java.util.HashMap;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class StatusCollector
implements StatusCollectorMBean {
    public StatusCollector() {
        try {
            MMbeanServer.getInstance().registerMBean(this, new ObjectName("Tools:name=StatusCollector"));
        }
        catch (Exception ex) {
            Log.info(ex);
        }
    }

    @Override
    public HashMap<String, Integer> collectStatus() {
        HashMap<String, Integer> statuses = new HashMap<String, Integer>();
        Set<ObjectName> mbeans = MMbeanServer.getInstance().queryNames(null, null);
        block7: for (ObjectName mbean : mbeans) {
            try {
                MBeanAttributeInfo[] mbeanInfor;
                for (MBeanAttributeInfo attInfo : mbeanInfor = MMbeanServer.getInstance().getMBeanInfo(mbean).getAttributes()) {
                    if (!attInfo.getName().equals("Status")) continue;
                    try {
                        statuses.put(mbean.toString(), (Integer)MMbeanServer.getInstance().getAttribute(mbean, "Status"));
                    }
                    catch (MBeanException ex) {
                        Log.info(ex);
                    }
                    catch (AttributeNotFoundException ex) {
                        Log.info(ex);
                    }
                    continue block7;
                }
            }
            catch (InstanceNotFoundException ex) {
                Log.info(ex);
            }
            catch (IntrospectionException ex) {
                Log.info(ex);
            }
            catch (ReflectionException ex) {
                Log.info(ex);
            }
        }
        return statuses;
    }
}

