/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.base;

import com.viettel.mmserver.agent.MMbeanServer;
import com.viettel.mmserver.base.Log;
import com.viettel.mmserver.base.ProcessManagerMBean;
import com.viettel.mmserver.base.ProcessThread;
import java.util.Hashtable;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class ProcessManager
extends StandardMBean
implements ProcessManagerMBean {
    private static ProcessManager instance;
    private final Hashtable<Integer, ProcessThread> mmProcesses = new Hashtable();

    private ProcessManager() throws NotCompliantMBeanException {
        super(ProcessManagerMBean.class);
        try {
            MMbeanServer.getInstance().registerMBean(this, new ObjectName("Tools:name=ProcessManager"));
        }
        catch (Exception ex) {
            Log.warn("Register JMX error", ex);
        }
    }

    public static synchronized ProcessManager getInstance() {
        try {
            if (instance == null) {
                instance = new ProcessManager();
            }
            return instance;
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("critical error when init ProcessManager!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMmProcess(ProcessThread process) {
        if (process != null) {
            Hashtable<Integer, ProcessThread> hashtable = this.mmProcesses;
            synchronized (hashtable) {
                this.mmProcesses.put(process.getId(), process);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessThread getMmProcess(Integer pid) {
        Hashtable<Integer, ProcessThread> hashtable = this.mmProcesses;
        synchronized (hashtable) {
            return this.mmProcesses.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill(Integer pid) {
        Hashtable<Integer, ProcessThread> hashtable = this.mmProcesses;
        synchronized (hashtable) {
            ProcessThread process = this.mmProcesses.get(pid);
            if (process != null) {
                process.stop();
                process = null;
            }
            this.mmProcesses.remove(pid);
        }
    }

    @Override
    public void cleanup() {
        for (ProcessThread process : this.mmProcesses.values()) {
            if (process.getState() != Thread.State.TERMINATED) continue;
            this.stop(process.getId());
        }
        this.mmProcesses.clear();
    }

    public Hashtable<Integer, ProcessThread> getMmProcess() {
        return this.mmProcesses;
    }

    @Override
    public String getProcessState(Integer pid) {
        ProcessThread process = this.getMmProcess(pid);
        if (process != null) {
            return process.toString();
        }
        return "process with pid " + pid + " not exist";
    }

    @Override
    public String listProcess() {
        StringBuilder sb = new StringBuilder("\n[MmProcess List]");
        for (ProcessThread process : this.mmProcesses.values()) {
            sb.append("\n" + process.toString());
        }
        sb.append("\n[End List]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unManageProcess(Integer pid) {
        Hashtable<Integer, ProcessThread> hashtable = this.mmProcesses;
        synchronized (hashtable) {
            this.mmProcesses.remove(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Integer pid) {
        Hashtable<Integer, ProcessThread> hashtable = this.mmProcesses;
        synchronized (hashtable) {
            ProcessThread process = this.mmProcesses.get(pid);
            if (process != null) {
                process.stop();
                Object var3_3 = null;
            }
        }
    }

    @Override
    public void stopAll() {
        Integer[] ids;
        for (Integer i : ids = this.mmProcesses.keySet().toArray(new Integer[this.mmProcesses.size()])) {
            ProcessThread process = this.mmProcesses.get(i);
            if (process == null) continue;
            process.stop();
            process = null;
        }
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "Ti\u1ebfn tr\u00ecnh qu\u1ea3n l\u00fd c\u00e1c Mm Process";
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        MBeanParameterInfo[] params = info.getSignature();
        String[] signature = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            signature[i] = params[i].getType();
        }
        if (info.getName().equals("cleanup")) {
            return "cleanup deadth process on system";
        }
        if (info.getName().equals("getProcessState")) {
            return "Tr\u1ea1ng th\u00e1i c\u1ee7a internal thread";
        }
        if (info.getName().equals("kill")) {
            return "H\u1ee7y ti\u1ebfn tr\u00ecnh MmProcess, y\u00eau c\u1ea7n ti\u1ebfn tr\u00ecnh d\u1eebng, n\u1ebfu h\u1ebft th\u1eddi gian timeout, s\u1ebd kill";
        }
        if (info.getName().equals("stop")) {
            return "Stop ti\u1ebfn tr\u00ecnh MmProcess";
        }
        if (info.getName().equals("stopAll")) {
            return "D\u1eebng t\u1ea5t c\u1ea3 c\u00e1c ti\u1ebfn tr\u00ecnh x\u1eed l\u00fd nghi\u1ec7p v\u1ee5";
        }
        if (info.getName().equals("resume")) {
            return "Ti\u1ebfp t\u1ee5c ch\u1ea1y ti\u1ebfn tr\u00ecnh n\u1ebfu \u0111ang suspend";
        }
        if (info.getName().equals("suspend")) {
            return "Suspend ti\u1ebfn tr\u00ecnh";
        }
        if (info.getName().equals("listProcess")) {
            return "Li\u1ec7t k\u00ea tr\u1ea1ng th\u00e1i c\u00e1c ti\u1ebfn tr\u00ecnh MmProcess trong h\u1ec7 th\u1ed1ng";
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("getProcessState") || op.getName().equals("kill") || op.getName().equals("listProcess") || op.getName().equals("resume") || op.getName().equals("stop") || op.getName().equals("suspend") || op.getName().equals("start")) {
            switch (sequence) {
                case 0: {
                    return "Pid c\u1ee7a MmProcess c\u1ea7n thao t\u00e1c";
                }
            }
            return null;
        }
        return null;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("getProcessState") || op.getName().equals("kill") || op.getName().equals("listProcess") || op.getName().equals("resume") || op.getName().equals("stop") || op.getName().equals("suspend") || op.getName().equals("start")) {
            switch (sequence) {
                case 0: {
                    return "process id";
                }
            }
            return null;
        }
        return null;
    }
}

