/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.base;

import com.viettel.mmserver.agent.MMbeanServer;
import com.viettel.mmserver.base.ConfigParamMBean;
import com.viettel.mmserver.base.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class ConfigParam
implements ConfigParamMBean {
    private static ConfigParam instance;
    private String appID = "";
    private String department = "";

    public static synchronized ConfigParam getInstance() {
        try {
            if (instance == null) {
                instance = new ConfigParam();
            }
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException("Critical error when init LogConfig!");
        }
    }

    public static synchronized ConfigParam getInstance(String appID, String department) {
        try {
            if (instance == null) {
                instance = new ConfigParam(appID, department);
            }
            return instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Critical error when init LogConfig!");
        }
    }

    public ConfigParam() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        MMbeanServer.getInstance().registerMBean(this, new ObjectName("Tools:name=ConfigParams"));
    }

    public ConfigParam(String appID, String department) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        if (appID != null) {
            this.appID = appID;
        }
        this.department = department;
        try {
            MMbeanServer.getInstance().registerMBean(this, new ObjectName("Tools:name=ConfigParams"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public String getAppID() {
        return this.appID;
    }

    @Override
    public String loadAppId() {
        return this.appID;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String loadParams(String strSource) {
        if (strSource != null) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(new DataInputStream(new FileInputStream(strSource))));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                String string = sb.toString();
                return string;
            }
            catch (Exception ex) {
                Log.error(ex);
                String string = "";
                return string;
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    Log.error(ex);
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveParams(String strConfig, String strSource) {
        if (strSource != null && strConfig != null) {
            Writer output = null;
            try {
                output = new BufferedWriter(new FileWriter(strSource));
                output.write(strConfig);
            }
            catch (Exception ex) {
                Log.error(ex);
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException ex) {
                        Log.error(ex);
                    }
                }
            }
        }
    }
}

