/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.base;

import com.viettel.mmserver.agent.MMbeanServer;
import com.viettel.mmserver.base.CommandInterfaceMBean;
import com.viettel.mmserver.base.Log;
import com.viettel.mmserver.base.StreamGobbler;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class CommandInterface
extends StandardMBean
implements CommandInterfaceMBean {
    private static CommandInterface comInterface;

    public static synchronized CommandInterface getInstance() {
        Log.info("Registering Command Interface");
        if (comInterface == null) {
            try {
                comInterface = new CommandInterface();
            }
            catch (Exception ex) {
                Log.error("Critical error when init CommandInterface");
                throw new RuntimeException("Critical error when init CommandInterface!");
            }
        }
        return comInterface;
    }

    public CommandInterface() throws NotCompliantMBeanException, MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException {
        super(CommandInterfaceMBean.class);
        MMbeanServer.getInstance().registerMBean(this, new ObjectName("Tools:name=CommandInterface"));
    }

    @Override
    public void callCommand(String args) {
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(args);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = proc.waitFor();
            Log.info("ExitValue: " + exitVal);
        }
        catch (Throwable t) {
            Log.error("Error in execute remote command");
            Log.error(t);
        }
    }
}

