/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.agent;

import com.viettel.mmserver.agent.MmJMXServerSec;
import com.viettel.mmserver.base.CommandInterface;
import com.viettel.mmserver.base.ConfigParam;
import com.viettel.mmserver.base.Log;
import com.viettel.mmserver.base.LogConfig;
import com.viettel.mmserver.base.MmLogManager;
import com.viettel.mmserver.base.StatusCollector;
import com.viettel.mmserver.log.appender.RegisterHostHandler;
import com.viettel.mmserver.scheduler.Scheduler;
import com.viettel.mmserver.warnning.BlockedThreadDetector;
import com.viettel.mmserver.warnning.ErrorDefinitionHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.log4j.PropertyConfigurator;

public final class JmxAgent {
    public static final String PRO_AGENT_PORT = "com.viettel.mmserver.agent.port";
    public static final String PRO_AGENT_IP = "com.viettel.mmserver.agent.ip";
    public static final String PUBLIC_IP = "java.rmi.server.hostname";
    public static final String PRO_AGENT_AUTHENTICATE = "com.viettel.mmserver.agent.authenticate";
    public static final String LOG4J_LOCATION = "com.viettel.mmserver.log4j.path";
    public static final String PRO_LOG4J_PORT = "com.viettel.mmserver.log4j.port";
    public static final String PRO_APP_ID = "com.viettel.mmserver.appid";
    public static final String PRO_DEPARTMENT = "com.viettel.mmserver.department";
    public static final String USE_SCHEDULER = "com.viettel.mmserver.scheduling";
    public static final String USE_ACTIONLOG = "com.viettel.mmserver.actionLog";
    public static final String DEFAULT_LOG4J_LOCATION = "../etc/log4j.cfg";
    public static final String BLOCKED_DETECT_ENABLE = "com.viettel.mmserver.blockedDetect.enable";
    public static final String DEFAULT_TIMEOUT = "com.viettel.mmserver.blockedDetect.defaultTimeout";
    public static final String DEFAULT_POOLING_PERIOD = "com.viettel.mmserver.blockedDetect.defaultPoolingPeriod";
    public static final String SEND_UNBLOCKED_SMS = "com.viettel.mmserver.blockedDetect.unblockedSMS";
    public static final String SEND_SMS = "com.viettel.mmserver.blockedDetect.defaultBlockedSMS";
    public static final String LOAD_BALANCING_AGENT = "com.viettel.mmserver.loadBalancingAgentClass";
    private static String ip = null;
    private static String publicIp = null;

    public static synchronized String getIp() {
        if (ip == null) {
            StringBuilder ipStringBuilder = new StringBuilder();
            Enumeration<NetworkInterface> interfaces = null;
            try {
                interfaces = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException e) {
                Log.info("Can not get server's IP address ", e);
            }
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface i = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = i.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress() || !address.isSiteLocalAddress()) continue;
                        ipStringBuilder.append(address.getHostAddress());
                        ipStringBuilder.append("/");
                    }
                }
                if (ipStringBuilder.length() > 0) {
                    ipStringBuilder.deleteCharAt(ipStringBuilder.length() - 1);
                    ip = ipStringBuilder.toString();
                } else {
                    ip = MmJMXServerSec.getIp();
                }
            } else {
                ip = MmJMXServerSec.getIp();
            }
        }
        return ip;
    }

    private JmxAgent() {
    }

    public static void premain(String args) throws Exception {
        String blockedDetectEnable;
        ConfigParam.getInstance(System.getProperty(PRO_APP_ID), System.getProperty(PRO_DEPARTMENT));
        String log4jConfigurationFile = System.getProperty(LOG4J_LOCATION);
        if (log4jConfigurationFile != null) {
            PropertyConfigurator.configure((String)log4jConfigurationFile);
        }
        Log.info("Starting M&M Server...");
        Log.info("Application ID: " + ConfigParam.getInstance().getAppID());
        String scheduling = System.getProperty(USE_SCHEDULER);
        if (scheduling == null || scheduling.trim().equals("1")) {
            Scheduler.getInstance("Scheduler").start();
        }
        if ((blockedDetectEnable = System.getProperty(BLOCKED_DETECT_ENABLE)) == null || blockedDetectEnable.equals("1")) {
            BlockedThreadDetector.getInstance().start();
        }
        Log.info("Register Status Collector");
        new StatusCollector();
        String loadBalacingAgent = System.getProperty(LOAD_BALANCING_AGENT);
        try {
            if (loadBalacingAgent != null && !loadBalacingAgent.equals("")) {
                Class<?> loadBalancingAgentClass = Class.forName(loadBalacingAgent);
                loadBalancingAgentClass.newInstance();
            }
        }
        catch (Exception ex) {
            Log.error("Error when load balencing agent " + ex);
        }
        Log.info("Initlizing a ErrorDefinitionHandler");
        ErrorDefinitionHandler.getInstance().start();
        Log.info("Initlized a ErrorDefinitionHandler");
        Log.info("Initlizing a RegisterHostHandler");
        RegisterHostHandler.getInstance().start();
        Log.info("Initlized a RegisterHostHandler");
        MmLogManager.getInstance();
        CommandInterface.getInstance();
        MmJMXServerSec.setPort(Integer.parseInt(System.getProperty(PRO_AGENT_PORT)));
        MmJMXServerSec.setIp(System.getProperty(PRO_AGENT_IP));
        Log.info("JmxAgent starting with ip: " + MmJMXServerSec.getIp() + " and port: " + MmJMXServerSec.getPort());
        MmJMXServerSec.getInstance().start();
        Log.info("JmxAgent started with ip: " + MmJMXServerSec.getIp() + " and port: " + MmJMXServerSec.getPort());
        publicIp = System.getProperty(PUBLIC_IP);
        if (publicIp == null) {
            LogConfig.getInstance(System.getProperty(PRO_AGENT_IP), Integer.parseInt(System.getProperty(PRO_LOG4J_PORT)));
        } else {
            LogConfig.getInstance(publicIp, Integer.parseInt(System.getProperty(PRO_LOG4J_PORT)));
        }
    }

    public static void main(String[] args) {
        try {
            PropertyConfigurator.configure((String)System.getProperty(LOG4J_LOCATION, DEFAULT_LOG4J_LOCATION));
            Log.info("Starting M&M Server...");
            ConfigParam.getInstance(System.getProperty(PRO_APP_ID), System.getProperty(PRO_DEPARTMENT));
            Log.info("Application ID: " + ConfigParam.getInstance().getAppID());
            Scheduler.getInstance("Scheduler").start();
            Log.info("Scheduler started");
            Log.info("Initlizing a ErrorDefinitionHandler");
            ErrorDefinitionHandler.getInstance().start();
            Log.info("Initlized a ErrorDefinitionHandler");
            MmLogManager.getInstance();
            CommandInterface.getInstance();
            MmJMXServerSec.setPort(Integer.parseInt(System.getProperty(PRO_AGENT_PORT)));
            MmJMXServerSec.setIp(System.getProperty(PRO_AGENT_IP));
            MmJMXServerSec.getInstance().start();
            Log.info("JmxAgent started with ip: " + MmJMXServerSec.getIp() + " and port: " + MmJMXServerSec.getPort());
            LogConfig.getInstance(System.getProperty(PRO_AGENT_IP), Integer.parseInt(System.getProperty(PRO_LOG4J_PORT)));
            Log.info("Log Socket with ip: " + LogConfig.getInstance().getLoggingIP() + " and port: " + LogConfig.getInstance().getLoggingPort());
            Log.info("M&M Server started!");
            if (args[0] != null && args[0].equals("stop")) {
                MmJMXServerSec.getInstance().stop();
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

