/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.http;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.proxy.ProxyAuthException;
import org.apache.mina.proxy.handlers.ProxyRequest;
import org.apache.mina.proxy.handlers.http.AbstractHttpLogicHandler;
import org.apache.mina.proxy.handlers.http.HttpProxyRequest;
import org.apache.mina.proxy.handlers.http.HttpProxyResponse;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthLogicHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAuthLogicHandler.class);
    protected ProxyRequest request;
    protected ProxyIoSession proxyIoSession;
    protected int step = 0;

    protected AbstractAuthLogicHandler(ProxyIoSession proxyIoSession) throws ProxyAuthException {
        this.proxyIoSession = proxyIoSession;
        this.request = proxyIoSession.getRequest();
    }

    public abstract void doHandshake(IoFilter.NextFilter var1) throws ProxyAuthException;

    public abstract void handleResponse(HttpProxyResponse var1) throws ProxyAuthException;

    protected void writeRequest(IoFilter.NextFilter nextFilter, HttpProxyRequest request) throws ProxyAuthException {
        logger.debug("  sending HTTP request");
        ((AbstractHttpLogicHandler)this.proxyIoSession.getHandler()).writeRequest(nextFilter, request);
    }
}

