/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.helpers;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import org.apache.log4j.helpers.QuietWriter;
import org.apache.log4j.spi.ErrorHandler;

public final class SynchronizedCountingQuietWriter
extends QuietWriter {
    private long charCount;

    public SynchronizedCountingQuietWriter(Writer writer, ErrorHandler eh) {
        super(writer, eh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(String string) {
        if (string == null) {
            this.errorHandler.error("Attempt to write null - see Log4J bug list.", (Exception)new RuntimeException("Fault in Log4J Layout"), 1);
            return;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                int length = string.length();
                this.out.write(string, 0, length);
                this.charCount += (long)length;
            }
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            this.errorHandler.error("Failed to write [" + string + "].", (Exception)e, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.out.flush();
            }
        }
        catch (IOException e) {
            this.errorHandler.error("Failed to flush writer,", (Exception)e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.charCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCount(long count) {
        Object object = this.lock;
        synchronized (object) {
            this.charCount = count;
        }
    }
}

