/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.apache.log4j.helpers.LogLog;

public final class FileHelper {
    private static final FileHelper INSTANCE = new FileHelper();
    private static final long MAGIC_ZIP = 67324752L;
    private static final long MAGIC_GZIP = 35615L;

    public static final FileHelper getInstance() {
        return INSTANCE;
    }

    private FileHelper() {
    }

    public long sizeOf(File file) {
        return this.isReadable(file) ? file.length() : 0L;
    }

    public boolean isEmpty(File file) {
        return this.sizeOf(file) == 0L;
    }

    public boolean deleteExisting(File file) {
        if (!file.exists()) {
            return true;
        }
        boolean deleted = false;
        if (file.canWrite()) {
            deleted = file.delete();
        } else {
            LogLog.debug((String)(file + " is not writeable for delete (retrying)"));
        }
        if (!deleted) {
            if (!file.exists()) {
                deleted = true;
            } else {
                file.delete();
                deleted = !file.exists();
            }
        }
        return deleted;
    }

    public boolean rename(File from, File to) {
        boolean renamed = false;
        if (this.isWriteable(from)) {
            renamed = from.renameTo(to);
        } else {
            LogLog.debug((String)(from + " is not writeable for rename (retrying)"));
        }
        if (!renamed) {
            from.renameTo(to);
            renamed = !from.exists();
        }
        return renamed;
    }

    public boolean isReadable(File file) {
        return file.exists() && file.canRead();
    }

    public boolean isWriteable(File file) {
        return file.exists() && file.canWrite();
    }

    public File parentDirOf(File file) {
        File parentDir = file.getParentFile();
        if (parentDir == null) {
            parentDir = new File(System.getProperty("user.dir"));
        }
        return parentDir;
    }

    public boolean isCompressed(File file) {
        return this.isZip(file) || this.isGZip(file);
    }

    public boolean isZip(File file) {
        long magic = 0L;
        if (this.isReadable(file)) {
            byte[] magicBytes = new byte[4];
            this.readBytes(file, magicBytes);
            magic = this.getUnsigned32Bit(magicBytes, 0);
        }
        return 67324752L == magic;
    }

    public boolean isGZip(File file) {
        long magic = 0L;
        if (this.isReadable(file)) {
            byte[] magicBytes = new byte[2];
            this.readBytes(file, magicBytes);
            magic = this.getUnsigned16Bit(magicBytes, 0);
        }
        return 35615L == magic;
    }

    private int getUnsigned16Bit(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8;
    }

    private long getUnsigned32Bit(byte[] bytes, int offset) {
        return (long)this.getUnsigned16Bit(bytes, offset) | (long)this.getUnsigned16Bit(bytes, offset + 2) << 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBytes(File file, byte[] bytes) {
        FileChannel channel = null;
        try {
            channel = new FileInputStream(file).getChannel();
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int bytesRead = channel.read(buffer);
            if (bytesRead != bytes.length) {
                LogLog.debug((String)"Incomplete log file");
            }
        }
        catch (ClosedByInterruptException e) {
            LogLog.debug((String)"Interrupted during log file read");
            Arrays.fill(bytes, (byte)0);
        }
        catch (FileNotFoundException e) {
            LogLog.debug((String)("Unable to open log file (it may have been scavenged) " + e.getMessage()));
            Arrays.fill(bytes, (byte)0);
        }
        catch (IOException e) {
            LogLog.error((String)"Unable to read log file", (Throwable)e);
            Arrays.fill(bytes, (byte)0);
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    LogLog.error((String)"Unable to close log file", (Throwable)e);
                }
            }
        }
    }
}

