/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import uk.org.simonsite.log4j.appender.AbstractRoller;
import uk.org.simonsite.log4j.appender.FileRollable;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;
import uk.org.simonsite.log4j.appender.TimeBasedRollStrategy;
import uk.org.simonsite.log4j.helpers.FileHelper;

final class TimeBasedRoller
extends AbstractRoller
implements FileRollable {
    private final TimeBasedRollStrategy rollStrategy;
    private TimeSample currentSample;
    private TimeSample previousSample;

    TimeBasedRoller(TimeAndSizeRollingAppender rollingAppender) {
        super(rollingAppender);
        TimeBasedRollStrategy rollStrategyEnum = TimeBasedRollStrategy.findRollStrategy(rollingAppender.getProperties());
        if (TimeBasedRollStrategy.ROLL_ERROR.equals(rollStrategyEnum)) {
            rollStrategyEnum = TimeBasedRollStrategy.ROLL_EACH_DAY;
            LogLog.warn((String)("Unable to parse date pattern [" + rollingAppender.getProperties().getDatePattern() + "] configured on appender [" + rollingAppender.getName() + "], defaulting to roll " + rollStrategyEnum.toString()));
        }
        LogLog.debug((String)("Appender [" + rollingAppender.getName() + "] to be rolled " + rollStrategyEnum.toString()));
        this.rollStrategy = rollStrategyEnum;
        this.currentSample = new TimeSample(System.currentTimeMillis());
        this.initNextRolloverTime();
    }

    public final boolean roll(LoggingEvent loggingEvent) {
        boolean rolled = false;
        this.takeTimeSample(loggingEvent);
        long nextRolloverTime = this.getNextRolloverTimeMillis();
        if (this.isRolloverDue(nextRolloverTime)) {
            super.roll(this.sampledTime());
            this.updateNextRolloverTime();
            rolled = true;
        }
        this.storeTimeSample();
        return rolled;
    }

    final TimeBasedRollStrategy getRollStrategy() {
        return this.rollStrategy;
    }

    private void takeTimeSample(LoggingEvent loggingEvent) {
        this.currentSample = new TimeSample(loggingEvent.getTimeStamp());
    }

    private long sampledTime() {
        if (this.previousSample == null) {
            File file = super.getAppender().getIoFile();
            this.previousSample = FileHelper.getInstance().isReadable(file) ? new TimeSample(file.lastModified()) : this.currentSample;
        }
        return this.previousSample.getMillis();
    }

    private void storeTimeSample() {
        if (this.currentSample.isAtOrAfter(this.previousSample)) {
            this.previousSample = this.currentSample;
            this.currentSample = null;
        }
    }

    private long getNextRolloverTimeMillis() {
        return this.getProperties().getNextRollOverTime();
    }

    private void setNextRolloverTimeMillis(long millis) {
        this.getProperties().setNextRollOverTime(millis);
    }

    private boolean isRolloverDue(long nextRolloverTime) {
        return this.currentSample.isAtOrAfter(nextRolloverTime);
    }

    private void initNextRolloverTime() {
        this.updateNextRolloverTime();
        File file = super.getAppender().getIoFile();
        if (FileHelper.getInstance().isReadable(file)) {
            long thenRolloverTimeMillis = this.rollStrategy.nextRollTimeInMillis(file.lastModified(), super.getProperties());
            if (thenRolloverTimeMillis < this.getNextRolloverTimeMillis()) {
                this.setNextRolloverTimeMillis(thenRolloverTimeMillis);
            }
        } else {
            super.getAppender().getErrorHandler().error("Unable to initialise next rollover time based upon last modification time of " + String.valueOf(file) + " because the file is not readable");
        }
    }

    private void updateNextRolloverTime() {
        long nowInMillis = this.currentSample.getMillis();
        long nextRollMillis = this.rollStrategy.nextRollTimeInMillis(nowInMillis, super.getProperties());
        this.setNextRolloverTimeMillis(nextRollMillis);
    }

    private final class TimeSample {
        private final long sample;

        TimeSample(long timeInMillis) {
            this.sample = timeInMillis;
        }

        long getMillis() {
            return this.sample;
        }

        boolean isAtOrAfter(long timeInMillis) {
            return this.sample >= timeInMillis;
        }

        boolean isAtOrAfter(TimeSample other) {
            return other != null ? this.sample >= other.sample : true;
        }
    }
}

