/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.LocalizedDateFormatPatternHelper;

abstract class TimeBasedRollStrategy {
    static final TimeBasedRollStrategy ROLL_ERROR = new TimeBasedRollStrategy(){

        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper localizedDateFormatPatternHelper, String datePattern) {
            return false;
        }

        final long nextRollTimeInMillis(long nowInMillis, AppenderRollingProperties properties) {
            return 0L;
        }

        public String toString() {
            return "error";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_MINUTE = new TimeBasedRollStrategy(){

        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper localizedDateFormatPatternHelper, String datePattern) {
            String patternRegex = localizedDateFormatPatternHelper.minutePatternRegex();
            return Pattern.matches(patternRegex, datePattern);
        }

        final long nextRollTimeInMillis(long nowInMillis, AppenderRollingProperties properties) {
            Calendar cal = Calendar.getInstance(properties.getTimeZone(), properties.getDatePatternLocale());
            cal.setTimeInMillis(nowInMillis);
            cal.set(14, 0);
            cal.set(13, 0);
            cal.add(12, 1);
            return cal.getTimeInMillis() + properties.getJumpStep() + properties.getRollingCyleShiftValue();
        }

        public String toString() {
            return "every minute";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_HOUR = new TimeBasedRollStrategy(){

        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper localizedDateFormatPatternHelper, String datePattern) {
            String patternRegex = localizedDateFormatPatternHelper.hourPatternRegex();
            return Pattern.matches(patternRegex, datePattern);
        }

        final long nextRollTimeInMillis(long nowInMillis, AppenderRollingProperties properties) {
            Calendar cal = Calendar.getInstance(properties.getTimeZone(), properties.getDatePatternLocale());
            cal.setTimeInMillis(nowInMillis);
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.add(11, 1);
            return cal.getTimeInMillis() + properties.getJumpStep() + properties.getRollingCyleShiftValue();
        }

        public String toString() {
            return "hourly";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_HALF_DAY = new TimeBasedRollStrategy(){

        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper localizedDateFormatPatternHelper, String datePattern) {
            String patternRegex = localizedDateFormatPatternHelper.amPmPatternRegex();
            return Pattern.matches(patternRegex, datePattern);
        }

        final long nextRollTimeInMillis(long nowInMillis, AppenderRollingProperties properties) {
            Calendar cal = Calendar.getInstance(properties.getTimeZone(), properties.getDatePatternLocale());
            cal.setTimeInMillis(nowInMillis);
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            int hour = cal.get(11);
            if (hour < 12) {
                cal.set(11, 12);
            } else {
                cal.set(11, 0);
                cal.add(5, 1);
            }
            return cal.getTimeInMillis() + properties.getJumpStep() + properties.getRollingCyleShiftValue();
        }

        public String toString() {
            return "half-daily";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_DAY = new TimeBasedRollStrategy(){

        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper localizedDateFormatPatternHelper, String datePattern) {
            String patternRegex = localizedDateFormatPatternHelper.dayPatternRegex();
            return Pattern.matches(patternRegex, datePattern);
        }

        final long nextRollTimeInMillis(long nowInMillis, AppenderRollingProperties properties) {
            Calendar cal = Calendar.getInstance(properties.getTimeZone(), properties.getDatePatternLocale());
            cal.setTimeInMillis(nowInMillis);
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            cal.add(5, 1);
            return cal.getTimeInMillis() + properties.getJumpStep() + properties.getRollingCyleShiftValue();
        }

        public String toString() {
            return "daily";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_WEEK = new TimeBasedRollStrategy(){

        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper localizedDateFormatPatternHelper, String datePattern) {
            String patternRegex = localizedDateFormatPatternHelper.weekPatternRegex();
            return Pattern.matches(patternRegex, datePattern);
        }

        final long nextRollTimeInMillis(long nowInMillis, AppenderRollingProperties properties) {
            Calendar cal = Calendar.getInstance(properties.getTimeZone(), properties.getDatePatternLocale());
            cal.setTimeInMillis(nowInMillis);
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            cal.set(7, cal.getFirstDayOfWeek());
            cal.add(3, 1);
            return cal.getTimeInMillis() + properties.getJumpStep() + properties.getRollingCyleShiftValue();
        }

        public String toString() {
            return "weekly";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_MONTH = new TimeBasedRollStrategy(){

        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper localizedDateFormatPatternHelper, String datePattern) {
            String patternRegex = localizedDateFormatPatternHelper.monthPatternRegex();
            return Pattern.matches(patternRegex, datePattern);
        }

        final long nextRollTimeInMillis(long nowInMillis, AppenderRollingProperties properties) {
            Calendar cal = Calendar.getInstance(properties.getTimeZone(), properties.getDatePatternLocale());
            cal.setTimeInMillis(nowInMillis);
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            cal.set(5, 1);
            cal.add(2, 1);
            return cal.getTimeInMillis() + properties.getJumpStep() + properties.getRollingCyleShiftValue();
        }

        public String toString() {
            return "monthly";
        }
    };
    static final TimeBasedRollStrategy ROLL_EACH_YEAR = new TimeBasedRollStrategy(){

        final boolean isRequiredStrategy(LocalizedDateFormatPatternHelper localizedDateFormatPatternHelper, String datePattern) {
            String patternRegex = localizedDateFormatPatternHelper.yearPatternRegex();
            return Pattern.matches(patternRegex, datePattern);
        }

        final long nextRollTimeInMillis(long nowInMillis, AppenderRollingProperties properties) {
            Calendar cal = Calendar.getInstance(properties.getTimeZone(), properties.getDatePatternLocale());
            cal.setTimeInMillis(nowInMillis);
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            cal.set(5, 1);
            cal.set(2, 1);
            cal.add(1, 1);
            return cal.getTimeInMillis() + properties.getJumpStep() + properties.getRollingCyleShiftValue();
        }

        public String toString() {
            return "annually";
        }
    };

    TimeBasedRollStrategy() {
    }

    static final TimeBasedRollStrategy findRollStrategy(AppenderRollingProperties properties) {
        String undecoratedDatePattern;
        if (properties.getDatePattern() == null) {
            LogLog.error((String)"null date pattern");
            return ROLL_ERROR;
        }
        LocalizedDateFormatPatternHelper localizedDateFormatPatternHelper = new LocalizedDateFormatPatternHelper(properties.getDatePatternLocale());
        if (ROLL_EACH_MINUTE.isRequiredStrategy(localizedDateFormatPatternHelper, undecoratedDatePattern = localizedDateFormatPatternHelper.excludeQuoted(properties.getDatePattern()))) {
            return ROLL_EACH_MINUTE;
        }
        if (ROLL_EACH_HOUR.isRequiredStrategy(localizedDateFormatPatternHelper, undecoratedDatePattern)) {
            return ROLL_EACH_HOUR;
        }
        if (ROLL_EACH_HALF_DAY.isRequiredStrategy(localizedDateFormatPatternHelper, undecoratedDatePattern)) {
            return ROLL_EACH_HALF_DAY;
        }
        if (ROLL_EACH_DAY.isRequiredStrategy(localizedDateFormatPatternHelper, undecoratedDatePattern)) {
            return ROLL_EACH_DAY;
        }
        if (ROLL_EACH_WEEK.isRequiredStrategy(localizedDateFormatPatternHelper, undecoratedDatePattern)) {
            return ROLL_EACH_WEEK;
        }
        if (ROLL_EACH_MONTH.isRequiredStrategy(localizedDateFormatPatternHelper, undecoratedDatePattern)) {
            return ROLL_EACH_MONTH;
        }
        if (ROLL_EACH_YEAR.isRequiredStrategy(localizedDateFormatPatternHelper, undecoratedDatePattern)) {
            return ROLL_EACH_YEAR;
        }
        return ROLL_ERROR;
    }

    abstract boolean isRequiredStrategy(LocalizedDateFormatPatternHelper var1, String var2);

    abstract long nextRollTimeInMillis(long var1, AppenderRollingProperties var3);
}

