/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.ScheduledFileRollEvent;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;

final class TimeBasedRollEnforcer
implements Runnable {
    private static final long TIME_OFFSET = 1000L;
    private final TimeAndSizeRollingAppender appender;
    private final AppenderRollingProperties properties;
    private volatile Thread threadRef = null;
    private long nextEnforcedRollTimeMillis = 0L;

    TimeBasedRollEnforcer(TimeAndSizeRollingAppender rollingAppender) {
        this.appender = rollingAppender;
        this.properties = rollingAppender.getProperties();
    }

    public final void run() {
        LogLog.debug((String)"Log time-based file-roll enforcer started");
        try {
            while (this.isRunning()) {
                try {
                    this.enforceRollSchedule();
                    Thread.sleep(this.sleepInterval());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Exception e) {
            this.appender.getErrorHandler().error("Log time-based file-roll enforcer failed", e, 0);
        }
        LogLog.debug((String)"Log time-based file-roll enforcer stopped");
    }

    final synchronized void begin() {
        if (this.threadRef == null && this.properties.isDateRollEnforced()) {
            Thread thread;
            this.threadRef = thread = new Thread((Runnable)this, "Log4J Time-based File-roll Enforcer");
            thread.setDaemon(true);
            thread.start();
        }
    }

    final synchronized void end() {
        Thread thread = this.threadRef;
        this.threadRef = null;
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean isScheduledRollTimeExceeded(long eventTime) {
        return eventTime > this.properties.getNextRollOverTime();
    }

    private boolean isRunning() {
        Thread thread = this.threadRef;
        return thread != null ? !thread.isInterrupted() : false;
    }

    private void enforceRollSchedule() {
        long eventTime = this.nextEnforcedRollTimeMillis;
        if (this.isScheduledRollTimeExceeded(eventTime)) {
            ScheduledFileRollEvent fileRollEvent = new ScheduledFileRollEvent(this.appender, eventTime);
            fileRollEvent.dispatchToAppender();
        }
        this.updateNextEnforcedRollTime(this.properties.getNextRollOverTimeWithWait());
    }

    private void updateNextEnforcedRollTime(long eventTime) {
        this.nextEnforcedRollTimeMillis = eventTime + 1000L;
    }

    private long sleepInterval() {
        long interval = this.nextEnforcedRollTimeMillis - System.currentTimeMillis();
        if (interval < 0L) {
            return 1000L;
        }
        return interval;
    }
}

