/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.CompositeRoller;
import uk.org.simonsite.log4j.appender.DefaultLogFileScavenger;
import uk.org.simonsite.log4j.appender.FileCompressionEventListener;
import uk.org.simonsite.log4j.appender.FileRollEvent;
import uk.org.simonsite.log4j.appender.FileRollEventListener;
import uk.org.simonsite.log4j.appender.FileRollEventSource;
import uk.org.simonsite.log4j.appender.FileRollable;
import uk.org.simonsite.log4j.appender.FileRoller;
import uk.org.simonsite.log4j.appender.LogFileCompressor;
import uk.org.simonsite.log4j.appender.LogFileScavenger;
import uk.org.simonsite.log4j.appender.ScheduledFileRollEvent;
import uk.org.simonsite.log4j.appender.StartupFileRollEvent;
import uk.org.simonsite.log4j.appender.TimeBasedRollEnforcer;
import uk.org.simonsite.log4j.helpers.SynchronizedCountingQuietWriter;

public final class TimeAndSizeRollingAppender
extends FileAppender
implements UnrecognizedElementHandler {
    private final AppenderRollingProperties properties = new AppenderRollingProperties();
    private FileRollable fileRollable = null;
    private FileRoller fileRoller = null;
    private LogFileScavenger logFileScavenger = null;
    private LogFileCompressor logFileCompressor = null;
    private TimeBasedRollEnforcer logRollEnforcer = null;
    private FileRollEventListener guestFileRollEventListener = null;
    private FileCompressionEventListener guestFileCompressionEventListener = null;

    public TimeAndSizeRollingAppender() {
        this.setFileRoller(new FileRoller(this));
    }

    public TimeAndSizeRollingAppender(Layout layout, String filename) throws IOException {
        this();
        this.initSuper(layout, filename, super.getAppend(), super.getBufferedIO(), super.getBufferSize());
    }

    public TimeAndSizeRollingAppender(Layout layout, String filename, boolean append) throws IOException {
        this();
        this.initSuper(layout, filename, append, super.getBufferedIO(), super.getBufferSize());
    }

    public TimeAndSizeRollingAppender(Layout layout, String filename, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        this();
        this.initSuper(layout, filename, append, bufferedIO, bufferSize);
    }

    private void initSuper(Layout layout, String filename, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setLayout(layout);
        super.setFile(filename);
        super.setAppend(append);
        super.setBufferedIO(bufferedIO);
        super.setBufferSize(bufferSize);
    }

    public final synchronized void activateOptions() {
        this.deactivateOptions();
        this.getProperties().setActivatingAppender(true);
        super.activateOptions();
        this.setFileRollable(new CompositeRoller(this));
        this.registerGuestFileRollEventListener();
        LogFileScavenger fileScavenger = this.getLogFileScavenger();
        if (fileScavenger == null) {
            fileScavenger = this.initLogFileScavenger(new DefaultLogFileScavenger());
        }
        fileScavenger.begin();
        LogFileCompressor logFileCompressor = new LogFileCompressor(this);
        this.setLogFileCompressor(logFileCompressor);
        this.getFileRoller().addFileRollEventListener(logFileCompressor);
        this.registerGuestFileCompressionEventListener();
        logFileCompressor.begin();
        TimeBasedRollEnforcer logRollEnforcer = new TimeBasedRollEnforcer(this);
        this.setLogRollEnforcer(logRollEnforcer);
        logRollEnforcer.begin();
        this.rollOnStartup();
        this.getProperties().setActivatingAppender(false);
    }

    public final synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closeFile();
        this.deactivateOptions();
        this.fileName = null;
        this.closed = true;
    }

    public final boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        Object scavenger;
        Object listener;
        String elementNodeName = element.getNodeName();
        if ("fileRollEventListener".equalsIgnoreCase(elementNodeName) && (listener = DOMConfigurator.parseElement((Element)element, (Properties)props, FileRollEventListener.class)) != null) {
            this.initGuestFileRollEventListener((FileRollEventListener)listener);
            return true;
        }
        if ("fileCompressionEventListener".equalsIgnoreCase(elementNodeName) && (listener = DOMConfigurator.parseElement((Element)element, (Properties)props, FileCompressionEventListener.class)) != null) {
            this.initGuestFileCompressionEventListener((FileCompressionEventListener)listener);
            return true;
        }
        if ("logFileScavenger".equalsIgnoreCase(elementNodeName) && (scavenger = DOMConfigurator.parseElement((Element)element, (Properties)props, LogFileScavenger.class)) != null) {
            this.initLogFileScavenger((LogFileScavenger)scavenger);
            return true;
        }
        return false;
    }

    public String getCompressionAlgorithm() {
        return this.getProperties().getCompressionAlgorithm();
    }

    public boolean getCompressionUseBlockingQueue() {
        return this.getProperties().isCompressionBlocking();
    }

    public long getCompressionMaxBlockingInterval() {
        return this.getProperties().getCompressionMaxWait();
    }

    public int getCompressionMinQueueSize() {
        return this.getProperties().getCompressionMinQueueSize();
    }

    public int getCompressionLevel() {
        return this.getProperties().getCompressionLevel();
    }

    public String getDatePattern() {
        return this.getProperties().getDatePattern();
    }

    public String getDatePatternLocale() {
        return this.getProperties().getDatePatternLocale().toString();
    }

    public boolean getDateRollEnforced() {
        return this.getProperties().isDateRollEnforced();
    }

    public String getFileRollEventListener() {
        return this.getGuestFileRollEventListener() != null ? this.getGuestFileRollEventListener().getClass().getName() : String.valueOf(this.getGuestFileRollEventListener());
    }

    public String getMaxFileSize() {
        return Long.toString(this.getProperties().getMaxFileSize());
    }

    public String getMinFreeDiskSpace() {
        return Long.toString(this.getProperties().getMinFreeDiscSpace());
    }

    public int getMaxRollFileCount() {
        return this.getProperties().getMaxRollFileCount();
    }

    public boolean getRollOnStartup() {
        return this.getProperties().shouldRollOnStartup();
    }

    public long getScavengeInterval() {
        return this.getProperties().getScavengeInterval();
    }

    public String getTimeZoneId() {
        return this.getProperties().getTimeZone().getID();
    }

    public String getDatePatternJump() {
        return this.getProperties().getDatePatternJump();
    }

    public void setDatePatternJump(String datePatternJump) {
        if (datePatternJump == null) {
            LogLog.warn((String)("Null name supplied for datePatternJump [" + this.getName() + "], defaulting to '" + this.getProperties().getDatePatternJump() + '\''));
            return;
        }
        try {
            String tmpJump = datePatternJump.trim();
            this.getProperties().setDatePatternJump(datePatternJump);
            String[] jumps = tmpJump.split(":");
            long jumpStep = (Long.parseLong(jumps[0]) * 3600L + Long.parseLong(jumps[1]) * 60L + Long.parseLong(jumps[2])) * 1000L;
            this.getProperties().setJumpStep(jumpStep);
            System.out.println("set datePatternJump " + this.getProperties().getJumpStep());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(" parse datePatternJump fail" + datePatternJump + ", set jum step to 0 ms");
        }
    }

    public void setRandomRangeForShift(long randomRangeForShift) {
        this.getProperties().setRandomRangeForShift(randomRangeForShift);
        long randomValue = Math.round(Math.random() * (double)randomRangeForShift) * 1000L;
        this.getProperties().setRollingCyleShiftValue(randomValue);
        System.out.println("set rolling cycle shift value to: " + this.getProperties().getRollingCyleShiftValue());
    }

    public long getRandomRangeForShift() {
        return this.getProperties().getRandomRangeForShift();
    }

    public void setCompressionAlgorithm(String compressionAlgorithm) {
        if (compressionAlgorithm == null) {
            LogLog.warn((String)("Null name supplied for compression algorithm [" + this.getName() + "], defaulting to '" + this.getProperties().getCompressionAlgorithm() + '\''));
            return;
        }
        if ("".equals(compressionAlgorithm = compressionAlgorithm.trim())) {
            LogLog.warn((String)("Empty name supplied for compression algorithm [" + this.getName() + "], defaulting to '" + this.getProperties().getCompressionAlgorithm() + '\''));
            return;
        }
        this.getProperties().setCompressionAlgorithm(compressionAlgorithm);
    }

    public void setCompressionUseBlockingQueue(boolean compressionBlockingQueue) {
        this.getProperties().setCompressionBlocking(compressionBlockingQueue);
    }

    public void setCompressionMaxBlockingInterval(long compressionInterval) {
        this.getProperties().setCompressionMaxWait(compressionInterval);
    }

    public void setCompressionLevel(int compressionLevel) {
        this.getProperties().setCompressionLevel(compressionLevel);
    }

    public void setCompressionMinQueueSize(int compressionMinQueueSize) {
        this.getProperties().setCompressionMinQueueSize(compressionMinQueueSize);
    }

    public void setDatePattern(String datePattern) {
        if (datePattern == null) {
            LogLog.warn((String)("Null date pattern supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getDatePattern()));
            return;
        }
        if ("".equals(datePattern = datePattern.trim())) {
            LogLog.warn((String)("Empty date pattern supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getDatePattern()));
            return;
        }
        this.getProperties().setDatePattern(datePattern);
    }

    public void setDatePatternLocale(String datePatternLocale) {
        if (datePatternLocale == null) {
            LogLog.warn((String)("Null date pattern locale supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getDatePatternLocale()));
            return;
        }
        if ("".equals(datePatternLocale = datePatternLocale.trim())) {
            LogLog.warn((String)("Empty date pattern locale supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getDatePatternLocale()));
            return;
        }
        String[] parts = datePatternLocale.split("_");
        switch (parts.length) {
            case 1: {
                this.getProperties().setDatePatternLocale(new Locale(parts[0]));
                break;
            }
            case 2: {
                this.getProperties().setDatePatternLocale(new Locale(parts[0], parts[1]));
                break;
            }
            default: {
                LogLog.warn((String)("Unable to parse date pattern locale supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getDatePatternLocale()));
            }
        }
    }

    public void setDateRollEnforced(boolean dateRollEnforced) {
        this.getProperties().setDateRollEnforced(dateRollEnforced);
    }

    public void setFileRollEventListener(String className) {
        FileRollEventListener fileRollEventListener;
        if (className != null && (fileRollEventListener = (FileRollEventListener)OptionConverter.instantiateByClassName((String)(className = className.trim()), FileRollEventListener.class, null)) != null) {
            this.initGuestFileRollEventListener(fileRollEventListener);
        }
    }

    public void setLogFileScavenger(String className) {
        LogFileScavenger logFileScavenger;
        if (className != null && (logFileScavenger = (LogFileScavenger)OptionConverter.instantiateByClassName((String)(className = className.trim()), LogFileScavenger.class, null)) != null) {
            this.initLogFileScavenger(logFileScavenger);
        }
    }

    public void setFileRollEventMessage(final String message) {
        if (message != null) {
            if (!"".equals(message.trim())) {
                this.initGuestFileRollEventListener(new FileRollEventListener(){

                    public final void onFileRoll(FileRollEvent fileRollEvent) {
                        fileRollEvent.dispatchToAppender(message);
                    }
                });
            } else {
                this.initGuestFileRollEventListener(new FileRollEventListener(){

                    public final void onFileRoll(FileRollEvent fileRollEvent) {
                        fileRollEvent.dispatchToAppender();
                    }
                });
            }
        }
    }

    public void setMaxFileSize(String value) {
        if (value == null) {
            LogLog.warn((String)("Null max file size supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getMaxFileSize()));
            return;
        }
        if ("".equals(value = value.trim())) {
            LogLog.warn((String)("Empty max file size supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getMaxFileSize()));
            return;
        }
        long defaultMaxFileSize = this.getProperties().getMaxFileSize();
        long maxFileSize = OptionConverter.toFileSize((String)value, (long)defaultMaxFileSize);
        this.getProperties().setMaxFileSize(maxFileSize);
    }

    public void setMinFreeDiskSpace(String value) {
        if (value == null) {
            LogLog.warn((String)("Null min free disk space supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getMinFreeDiscSpace()));
            return;
        }
        if ("".equals(value = value.trim())) {
            LogLog.warn((String)("Empty min free disk space supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getMinFreeDiscSpace()));
            return;
        }
        long defaultMinFreeDiskSpace = this.getProperties().getMinFreeDiscSpace();
        long minFreeDiskSpace = OptionConverter.toFileSize((String)value, (long)defaultMinFreeDiskSpace);
        this.getProperties().setMinFreeDiscSpace(minFreeDiskSpace);
    }

    public void setMaxRollFileCount(int maxRollFileCount) {
        this.getProperties().setMaxRollFileCount(maxRollFileCount);
    }

    public void setRollOnStartup(boolean rollOnStartup) {
        this.getProperties().setRollOnStartup(rollOnStartup);
    }

    public void setScavengeInterval(long intervalMillis) {
        this.getProperties().setScavengeInterval(intervalMillis);
    }

    public void setMinFreeDiskSpace(long minFreeDiskSpace) {
        this.getProperties().setMinFreeDiscSpace(minFreeDiskSpace);
    }

    public void setTimeZoneId(String timeZoneId) {
        if (timeZoneId == null) {
            LogLog.warn((String)("Null time zone ID supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getTimeZone()));
            return;
        }
        if ("".equals(timeZoneId = timeZoneId.trim())) {
            LogLog.warn((String)("Empty time zone ID supplied for appender [" + this.getName() + "], defaulting to " + this.getProperties().getTimeZone()));
            return;
        }
        TimeZone timeZone = null;
        String[] timeZoneIdArray = TimeZone.getAvailableIDs();
        for (int i = 0; i < timeZoneIdArray.length; ++i) {
            if (!timeZoneIdArray[i].equals(timeZoneId)) continue;
            timeZone = TimeZone.getTimeZone(timeZoneId);
            break;
        }
        if (timeZone == null) {
            LogLog.warn((String)("Supplied time zone ID not known for appender [" + this.getName() + "], defaulting to " + this.getProperties().getTimeZone()));
            return;
        }
        this.getProperties().setTimeZone(timeZone);
    }

    final FileRoller getFileRoller() {
        return this.fileRoller;
    }

    final FileRollEventListener getGuestFileRollEventListener() {
        return this.guestFileRollEventListener;
    }

    final FileCompressionEventListener getGuestFileCompressionEventListener() {
        return this.guestFileCompressionEventListener;
    }

    final LogFileCompressor getLogFileCompressor() {
        return this.logFileCompressor;
    }

    final LogFileScavenger getLogFileScavenger() {
        return this.logFileScavenger;
    }

    final AppenderRollingProperties getProperties() {
        return this.properties;
    }

    final File getIoFile() {
        String fileName = super.getFile();
        if (fileName == null) {
            super.getErrorHandler().error("Filename has not been set", (Exception)new IllegalStateException(), 4);
            return null;
        }
        return new File(fileName);
    }

    final void openFile() {
        super.activateOptions();
    }

    protected final void closeFile() {
        this.writeFooter();
        super.closeWriter();
        this.qw = null;
    }

    protected final void setQWForFiles(Writer writer) {
        SynchronizedCountingQuietWriter countingQuietWriter = new SynchronizedCountingQuietWriter(writer, super.getErrorHandler());
        this.getProperties().setCountingQuietWriter(countingQuietWriter);
        this.qw = countingQuietWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void subAppend(LoggingEvent event) {
        if (event instanceof ScheduledFileRollEvent) {
            TimeAndSizeRollingAppender timeAndSizeRollingAppender = this;
            synchronized (timeAndSizeRollingAppender) {
                if (this.closed) {
                    return;
                }
                this.rollFile(event);
            }
        } else if (event instanceof FileRollEvent) {
            super.subAppend(event);
        } else {
            this.rollFile(event);
            super.subAppend(event);
        }
    }

    protected final void writeFooter() {
        if (this.getProperties().isActivatingAppender()) {
            return;
        }
        super.writeFooter();
    }

    protected final void writeHeader() {
        if (this.getProperties().shouldRollOnActivation()) {
            return;
        }
        super.writeHeader();
    }

    private synchronized void deactivateOptions() {
        FileRollEventSource fileRollEventSource;
        LogFileCompressor logFileCompressor;
        TimeBasedRollEnforcer logRollEnforcer;
        LogFileScavenger logFileScavenger = this.getLogFileScavenger();
        if (logFileScavenger != null) {
            logFileScavenger.end();
        }
        if ((logRollEnforcer = this.getLogRollEnforcer()) != null) {
            logRollEnforcer.end();
        }
        if ((logFileCompressor = this.getLogFileCompressor()) != null) {
            logFileCompressor.end();
        }
        if ((fileRollEventSource = this.getFileRollEventSource()) != null) {
            fileRollEventSource.removeFileRollEventListener(logFileCompressor);
        }
        this.deregisterGuestFileRollEventListener();
        this.deregisterGuestFileCompressionEventListener();
    }

    private void deregisterGuestFileRollEventListener() {
        FileRollEventSource fileRollEventSource;
        FileRollEventListener listener = this.getGuestFileRollEventListener();
        if (listener != null && (fileRollEventSource = this.getFileRollEventSource()) != null) {
            fileRollEventSource.removeFileRollEventListener(listener);
        }
    }

    private void deregisterGuestFileCompressionEventListener() {
        LogFileCompressor logFileCompressor;
        FileCompressionEventListener listener = this.getGuestFileCompressionEventListener();
        if (listener != null && (logFileCompressor = this.getLogFileCompressor()) != null) {
            logFileCompressor.removeFileCompressionEventListener(listener);
        }
    }

    private void registerGuestFileRollEventListener() {
        FileRollEventSource fileRollEventSource;
        FileRollEventListener listener = this.getGuestFileRollEventListener();
        if (listener != null && (fileRollEventSource = this.getFileRollEventSource()) != null) {
            fileRollEventSource.addFileRollEventListener(listener);
        }
    }

    private void registerGuestFileCompressionEventListener() {
        LogFileCompressor logFileCompressor;
        FileCompressionEventListener listener = this.getGuestFileCompressionEventListener();
        if (listener != null && (logFileCompressor = this.getLogFileCompressor()) != null) {
            logFileCompressor.addFileCompressionEventListener(listener);
        }
    }

    private void rollFile(LoggingEvent event) {
        this.getFileRollable().roll(event);
    }

    private void rollOnStartup() {
        if (this.getProperties().shouldRollOnActivation()) {
            this.rollFile(new StartupFileRollEvent());
        }
    }

    private FileRollable getFileRollable() {
        return this.fileRollable;
    }

    private void setFileRollable(FileRollable fileRollable) {
        this.fileRollable = fileRollable;
    }

    private FileRollEventSource getFileRollEventSource() {
        return this.getFileRoller();
    }

    private void setFileRoller(FileRoller fileRoller) {
        this.fileRoller = fileRoller;
    }

    private void initGuestFileRollEventListener(FileRollEventListener guestListener) {
        this.deregisterGuestFileRollEventListener();
        this.guestFileRollEventListener = guestListener;
    }

    private void initGuestFileCompressionEventListener(FileCompressionEventListener guestListener) {
        this.deregisterGuestFileCompressionEventListener();
        this.guestFileCompressionEventListener = guestListener;
    }

    private LogFileScavenger initLogFileScavenger(LogFileScavenger logFileScavenger) {
        if (this.logFileScavenger != null) {
            this.logFileScavenger.end();
        }
        logFileScavenger.init(this, this.getProperties());
        this.logFileScavenger = logFileScavenger;
        return logFileScavenger;
    }

    private void setLogFileCompressor(LogFileCompressor logFileCompressor) {
        if (this.logFileCompressor != null) {
            this.logFileCompressor.end();
        }
        this.logFileCompressor = logFileCompressor;
    }

    private TimeBasedRollEnforcer getLogRollEnforcer() {
        return this.logRollEnforcer;
    }

    private void setLogRollEnforcer(TimeBasedRollEnforcer logRollEnforcer) {
        if (this.logRollEnforcer != null) {
            this.logRollEnforcer.end();
        }
        this.logRollEnforcer = logRollEnforcer;
    }
}

