/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.io.FilenameFilter;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.BackupSuffixHelper;
import uk.org.simonsite.log4j.helpers.FileHelper;

final class LogFileList
extends AbstractList
implements List {
    private final BackupSuffixHelper backupSuffixHelper;
    private final File baseFile;
    private final FileHelper fileHelper;
    private File[] fileArray;
    private int size;
    private final FilenameFilter filenameFilter;

    LogFileList(File baseFile, FilenameFilter filenameFilter, AppenderRollingProperties properties) {
        this.backupSuffixHelper = new BackupSuffixHelper(properties);
        this.baseFile = baseFile;
        this.fileArray = new File[0];
        this.fileHelper = FileHelper.getInstance();
        this.filenameFilter = filenameFilter;
        this.init();
    }

    public final Object get(int index) {
        this.rangeCheck(index);
        return this.fileArray[index];
    }

    public final Object remove(int index) {
        this.rangeCheck(index);
        ++this.modCount;
        File oldValue = this.fileArray[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.fileArray, index + 1, this.fileArray, index, numMoved);
        }
        this.fileArray[--this.size] = null;
        return oldValue;
    }

    public final int size() {
        return this.size;
    }

    final File firstFile() {
        return this.size > 0 ? this.fileArray[0] : null;
    }

    final File lastFile() {
        return this.size > 0 ? this.fileArray[this.size - 1] : null;
    }

    private void init() {
        File dir = null;
        dir = this.baseFile.isDirectory() ? this.baseFile : this.fileHelper.parentDirOf(this.baseFile);
        if (dir != null) {
            this.readFileListFrom(dir);
            this.sortFileList();
        }
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private void readFileListFrom(File dir) {
        if (this.fileHelper.isReadable(dir)) {
            File[] files;
            File[] fileArray = files = this.filenameFilter != null ? dir.listFiles(this.filenameFilter) : dir.listFiles();
            if (files != null) {
                this.fileArray = files;
                this.size = files.length;
            }
        }
    }

    private void sortFileList() {
        if (this.size > 1) {
            Arrays.sort(this.fileArray, new Comparator(){

                public final int compare(Object o1, Object o2) {
                    int f2Count;
                    File f1 = (File)o1;
                    File f2 = (File)o2;
                    Number[] f1TimeAndCount = LogFileList.this.backupSuffixHelper.backupTimeAndCount(f1.getName(), LogFileList.this.baseFile);
                    Number[] f2TimeAndCount = LogFileList.this.backupSuffixHelper.backupTimeAndCount(f2.getName(), LogFileList.this.baseFile);
                    long f1TimeSuffix = f1TimeAndCount[0].longValue();
                    long f2TimeSuffix = f2TimeAndCount[0].longValue();
                    if (0L == f1TimeSuffix && 0L == f2TimeSuffix) {
                        long f2Time;
                        long f1Time = f1.lastModified();
                        if (f1Time < (f2Time = f2.lastModified())) {
                            return -1;
                        }
                        if (f1Time > f2Time) {
                            return 1;
                        }
                        return 0;
                    }
                    if (f1TimeSuffix < f2TimeSuffix) {
                        return -1;
                    }
                    if (f1TimeSuffix > f2TimeSuffix) {
                        return 1;
                    }
                    int f1Count = f1TimeAndCount[1].intValue();
                    if (f1Count < (f2Count = f2TimeAndCount[1].intValue())) {
                        return -1;
                    }
                    if (f1Count > f2Count) {
                        return 1;
                    }
                    if (f1Count == f2Count) {
                        if (LogFileList.this.fileHelper.isCompressed(f1)) {
                            return -1;
                        }
                        if (LogFileList.this.fileHelper.isCompressed(f2)) {
                            return 1;
                        }
                    }
                    return 0;
                }
            });
        }
    }
}

