/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.FileCompressionEvent;
import uk.org.simonsite.log4j.appender.FileCompressionEventListener;
import uk.org.simonsite.log4j.appender.FileRollEvent;
import uk.org.simonsite.log4j.appender.FileRollEventListener;
import uk.org.simonsite.log4j.appender.LogFileCompressionStrategy;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;
import uk.org.simonsite.log4j.helpers.FileHelper;

final class LogFileCompressor
implements Runnable,
FileRollEventListener {
    private static final int QUEUE_LIMIT = 64;
    private final TimeAndSizeRollingAppender appender;
    private final AppenderRollingProperties properties;
    private volatile Thread threadRef = null;
    private final List queue;
    private final List fileCompressionEventListeners;

    LogFileCompressor(TimeAndSizeRollingAppender rollingAppender) {
        this.appender = rollingAppender;
        this.properties = rollingAppender.getProperties();
        this.queue = new LinkedList();
        this.fileCompressionEventListeners = Collections.synchronizedList(new ArrayList());
    }

    public final void run() {
        LogLog.debug((String)"Log file compressor started");
        try {
            while (this.isRunning()) {
                try {
                    this.compressNext();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (InterruptedIOException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Exception e) {
            this.appender.getErrorHandler().error("Log file compressor failed", e, 0);
        }
        LogLog.debug((String)"Log file compressor stopped");
    }

    public final void onFileRoll(FileRollEvent fileRollEvent) {
        this.compress(fileRollEvent.getBackupFile());
    }

    final int getQueueLimit() {
        return 64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getQueueSize() {
        int size = 0;
        List list = this.queue;
        synchronized (list) {
            size = this.queue.size();
            this.queue.notifyAll();
        }
        return size;
    }

    final void waitForEmptyQueue() {
        this.waitForSizeQueue(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void waitForSizeQueue(int queueSize) {
        List list = this.queue;
        synchronized (list) {
            while (this.queue.size() > queueSize) {
                try {
                    this.queue.wait(250L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.queue.notifyAll();
        }
    }

    final synchronized void begin() {
        if (this.threadRef == null && LogFileCompressionStrategy.existsFor(this.properties)) {
            Thread thread;
            this.threadRef = thread = new Thread((Runnable)this, "Log4J File Compressor");
            thread.setDaemon(true);
            thread.start();
        }
    }

    final synchronized void end() {
        Thread thread = this.threadRef;
        this.threadRef = null;
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void compress(File file) {
        if (this.isRunning()) {
            List list = this.queue;
            synchronized (list) {
                while (this.queue.size() > 64) {
                    if (this.properties.isCompressionBlocking()) {
                        try {
                            this.queue.wait(this.properties.getCompressionMaxWait());
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    this.queue.remove(0);
                }
                this.queue.add(file);
                this.queue.notifyAll();
            }
        }
    }

    final void addFileCompressionEventListener(FileCompressionEventListener fileCompressionEventListener) {
        this.fileCompressionEventListeners.add(fileCompressionEventListener);
    }

    final void removeFileCompressionEventListener(FileCompressionEventListener fileCompressionEventListener) {
        this.fileCompressionEventListeners.remove(fileCompressionEventListener);
    }

    final void fireFileCompressionEvent(FileCompressionEvent fileCompressionEvent) {
        Object[] listeners = this.fileCompressionEventListeners.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            FileCompressionEventListener listener = (FileCompressionEventListener)listeners[i];
            try {
                listener.onFileCompression(fileCompressionEvent);
                continue;
            }
            catch (RuntimeException e) {
                this.appender.getErrorHandler().error("Failed to dispatch file compression event", (Exception)e, 0);
            }
        }
    }

    private boolean isRunning() {
        Thread thread = this.threadRef;
        return thread != null ? !thread.isInterrupted() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueBelowMinSize() {
        boolean belowMinSize = false;
        List list = this.queue;
        synchronized (list) {
            int compressionMinQueueSize = this.properties.getCompressionMinQueueSize();
            belowMinSize = compressionMinQueueSize > 0 ? this.queue.size() < compressionMinQueueSize : this.queue.isEmpty();
            this.queue.notifyAll();
        }
        return belowMinSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressNext() throws InterruptedException, InterruptedIOException {
        File file = null;
        List list = this.queue;
        synchronized (list) {
            while (this.queueBelowMinSize()) {
                this.queue.wait(this.properties.getCompressionMaxWait());
            }
            file = (File)this.queue.remove(0);
            this.queue.notifyAll();
        }
        if (file != null) {
            this.doCompression(file);
        }
    }

    private void doCompression(File file) {
        File deflatedFile;
        LogFileCompressionStrategy compressionStrategy;
        if (FileHelper.getInstance().isWriteable(file) && (compressionStrategy = LogFileCompressionStrategy.findCompressionStrategy(this.properties)) != null && (deflatedFile = compressionStrategy.compress(file, this.properties)) != null) {
            this.fireFileCompressionEvent(new FileCompressionEvent(deflatedFile));
        }
    }
}

