/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.text.DateFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.helpers.LogLog;

final class LocalizedDateFormatPatternHelper {
    private static final String ANY = ".*";
    private static final String OR = ".*|.*";
    private final DateFormatSymbols symbols;

    LocalizedDateFormatPatternHelper(Locale datePatternLocale) {
        this.symbols = new DateFormatSymbols(datePatternLocale);
    }

    final String minutePatternRegex() {
        StringBuffer regex = new StringBuffer();
        String pattern = this.symbols.getLocalPatternChars();
        regex.append(ANY);
        regex.append(pattern.charAt(6));
        regex.append(ANY);
        return regex.toString();
    }

    final String hourPatternRegex() {
        StringBuffer regex = new StringBuffer();
        String pattern = this.symbols.getLocalPatternChars();
        regex.append(ANY);
        regex.append(pattern.charAt(16));
        regex.append(OR);
        regex.append(pattern.charAt(15));
        regex.append(OR);
        regex.append(pattern.charAt(5));
        regex.append(OR);
        regex.append(pattern.charAt(4));
        regex.append(ANY);
        return regex.toString();
    }

    final String amPmPatternRegex() {
        StringBuffer regex = new StringBuffer();
        String pattern = this.symbols.getLocalPatternChars();
        regex.append(ANY);
        regex.append(pattern.charAt(14));
        regex.append(ANY);
        return regex.toString();
    }

    final String dayPatternRegex() {
        StringBuffer regex = new StringBuffer();
        String pattern = this.symbols.getLocalPatternChars();
        regex.append(ANY);
        regex.append(pattern.charAt(3));
        regex.append(OR);
        regex.append(pattern.charAt(9));
        regex.append(OR);
        regex.append(pattern.charAt(11));
        regex.append(OR);
        regex.append(pattern.charAt(10));
        regex.append(ANY);
        return regex.toString();
    }

    final String weekPatternRegex() {
        StringBuffer regex = new StringBuffer();
        String pattern = this.symbols.getLocalPatternChars();
        regex.append(ANY);
        regex.append(pattern.charAt(13));
        regex.append(OR);
        regex.append(pattern.charAt(12));
        regex.append(ANY);
        return regex.toString();
    }

    final String monthPatternRegex() {
        StringBuffer regex = new StringBuffer();
        String pattern = this.symbols.getLocalPatternChars();
        regex.append(ANY);
        regex.append(pattern.charAt(2));
        regex.append(ANY);
        return regex.toString();
    }

    final String yearPatternRegex() {
        StringBuffer regex = new StringBuffer();
        String pattern = this.symbols.getLocalPatternChars();
        regex.append(ANY);
        regex.append(pattern.charAt(1));
        regex.append(ANY);
        return regex.toString();
    }

    final String excludeQuoted(String datePattern) {
        Pattern pattern = Pattern.compile("'('{2}|[^'])+'");
        Matcher matcher = pattern.matcher(datePattern);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "");
        }
        matcher.appendTail(buffer);
        LogLog.debug((String)("DatePattern reduced to " + buffer.toString() + " for computation of time-based rollover strategy (full pattern" + " will be used for actual roll-file naming)"));
        return buffer.toString();
    }
}

