/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.BackupSuffixHelper;
import uk.org.simonsite.log4j.appender.FileRollEvent;
import uk.org.simonsite.log4j.appender.FileRollEventListener;
import uk.org.simonsite.log4j.appender.FileRollEventSource;
import uk.org.simonsite.log4j.appender.LogFileList;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;
import uk.org.simonsite.log4j.helpers.FileHelper;

final class FileRoller
implements FileRollEventSource {
    private final TimeAndSizeRollingAppender appender;
    private final AppenderRollingProperties properties;
    private final BackupSuffixHelper backupSuffixHelper;
    private final List fileRollEventListeners = Collections.synchronizedList(new ArrayList());

    FileRoller(TimeAndSizeRollingAppender rollingAppender) {
        this.appender = rollingAppender;
        this.properties = rollingAppender.getProperties();
        this.backupSuffixHelper = new BackupSuffixHelper(this.properties);
    }

    public final void addFileRollEventListener(FileRollEventListener fileRollEventListener) {
        this.fileRollEventListeners.add(fileRollEventListener);
    }

    public final void removeFileRollEventListener(FileRollEventListener fileRollEventListener) {
        this.fileRollEventListeners.remove(fileRollEventListener);
    }

    public final void fireFileRollEvent(FileRollEvent fileRollEvent) {
        Object[] listeners = this.fileRollEventListeners.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            FileRollEventListener listener = (FileRollEventListener)listeners[i];
            try {
                listener.onFileRoll(fileRollEvent);
                continue;
            }
            catch (RuntimeException e) {
                this.getAppender().getErrorHandler().error("Failed to dispatch file roll event", (Exception)e, 0);
            }
        }
    }

    final TimeAndSizeRollingAppender getAppender() {
        return this.appender;
    }

    final AppenderRollingProperties getProperties() {
        return this.properties;
    }

    final void roll(long timeForSuffix) {
        File backupFile = this.prepareBackupFile(timeForSuffix);
        this.getAppender().closeFile();
        this.doFileRoll(this.getAppender().getIoFile(), backupFile);
        this.getAppender().openFile();
        this.fireFileRollEvent(new FileRollEvent(this, backupFile));
    }

    private File prepareBackupFile(long timeForSuffix) {
        String timeSuffix = this.backupSuffixHelper.backupTimeAsString(timeForSuffix);
        BackupFile backupFile = new BackupFile(this.getAppender().getIoFile(), timeSuffix);
        LogFileList logFileList = this.logFileListFilteredOn(backupFile);
        String backupCountSuffix = this.backupSuffixHelper.defaultBackupCountAsString();
        if (!logFileList.isEmpty()) {
            File lastLogFile = logFileList.lastFile();
            backupCountSuffix = this.backupSuffixHelper.nextBackupCountAsString(lastLogFile.getName(), backupFile.getBaseFile());
        }
        backupFile.setBackupCountSuffix(backupCountSuffix);
        return backupFile.getBackupFile();
    }

    private LogFileList logFileListFilteredOn(BackupFile backupFile) {
        LogLog.debug((String)"Reading in list of existing log files");
        final String timeSuffixedFilename = backupFile.getTimeSuffixedFile().getName();
        return new LogFileList(backupFile.getBaseFile(), new FilenameFilter(){

            public final boolean accept(File logDir, String name) {
                return name.startsWith(timeSuffixedFilename);
            }
        }, this.getProperties());
    }

    private void doFileRoll(File from, File to) {
        FileHelper fileHelper = FileHelper.getInstance();
        if (!fileHelper.deleteExisting(to)) {
            this.getAppender().getErrorHandler().error("Unable to delete existing " + to + " for rename");
        }
        String original = from.toString();
        if (fileHelper.rename(from, to)) {
            LogLog.debug((String)("Renamed " + original + " to " + to));
        } else {
            this.getAppender().getErrorHandler().error("Unable to rename " + original + " to " + to);
        }
    }

    private static final class BackupFile {
        private final File baseFile;
        private final File timeSuffixedFile;
        private String backupCountSuffix = "";

        BackupFile(File logFile, String timeSuffix) {
            this.baseFile = logFile;
            this.timeSuffixedFile = new File(logFile.getAbsoluteFile() + timeSuffix);
        }

        final void setBackupCountSuffix(String backupCountSuffix) {
            this.backupCountSuffix = backupCountSuffix;
        }

        final File getBaseFile() {
            return this.baseFile;
        }

        final File getTimeSuffixedFile() {
            return this.timeSuffixedFile;
        }

        final File getBackupFile() {
            return new File(this.timeSuffixedFile.getPath() + '.' + this.backupCountSuffix);
        }
    }
}

