/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import uk.org.simonsite.log4j.appender.FileRoller;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;

public final class FileRollEvent
extends LoggingEvent {
    private static final long serialVersionUID = 3505480003597965824L;
    private final File backupFile;
    private transient TimeAndSizeRollingAppender source;
    private final String sourceName;

    FileRollEvent(FileRoller source, File backupFile) {
        super(Logger.class.getName(), (Category)Logger.getRootLogger(), System.currentTimeMillis(), (Priority)Level.ALL, (Object)("Log4J file roll event" + System.getProperty("line.separator")), null);
        this.backupFile = backupFile;
        this.source = source.getAppender();
        this.sourceName = this.source.getName();
    }

    private FileRollEvent(FileRollEvent original, String message) {
        super(Logger.class.getName(), (Category)Logger.getRootLogger(), System.currentTimeMillis(), (Priority)Level.ALL, (Object)(String.valueOf(message) + System.getProperty("line.separator")), null);
        this.backupFile = original.backupFile;
        this.source = original.getSource();
        this.sourceName = this.source.getName();
    }

    private FileRollEvent(LoggingEvent loggingEvent, FileRollEvent fileRollEvent) {
        super(loggingEvent.getFQNOfLoggerClass(), loggingEvent.getLogger(), loggingEvent.getTimeStamp(), loggingEvent.getLevel(), loggingEvent.getMessage(), loggingEvent.getThreadName(), loggingEvent.getThrowableInformation(), loggingEvent.getNDC(), loggingEvent.getLocationInformation(), loggingEvent.getProperties());
        this.backupFile = fileRollEvent.backupFile;
        this.source = fileRollEvent.getSource();
        this.sourceName = this.source.getName();
    }

    public final File getBackupFile() {
        return this.backupFile;
    }

    private TimeAndSizeRollingAppender getSource() {
        if (this.source == null) {
            Appender appender = super.getLogger().getAppender(this.sourceName);
            if (appender == null) {
                LogLog.error((String)("Missing " + TimeAndSizeRollingAppender.class.getName() + "; expected to be attached to the Logger that created this " + ((Object)((Object)this)).getClass().getName()));
                return null;
            }
            if (appender instanceof TimeAndSizeRollingAppender) {
                this.source = (TimeAndSizeRollingAppender)appender;
            } else {
                LogLog.error((String)("Expected " + TimeAndSizeRollingAppender.class.getName() + " but was " + appender.getClass().getName()));
            }
        }
        return this.source;
    }

    final void dispatchToAppender(String message) {
        TimeAndSizeRollingAppender appender = this.getSource();
        if (appender != null) {
            appender.append(new FileRollEvent(this, message));
        }
    }

    final void dispatchToAppender() {
        TimeAndSizeRollingAppender appender = this.getSource();
        if (appender != null) {
            appender.append(this);
        }
    }

    final void dispatchToAppender(LoggingEvent customLoggingEvent) {
        TimeAndSizeRollingAppender appender = this.getSource();
        if (appender != null) {
            appender.append(new FileRollEvent(customLoggingEvent, this));
        }
    }
}

