/*
 * Decompiled with CFR 0.152.
 */
package uk.org.simonsite.log4j.appender;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.log4j.helpers.LogLog;
import uk.org.simonsite.log4j.appender.AppenderRollingProperties;
import uk.org.simonsite.log4j.appender.LogFileList;
import uk.org.simonsite.log4j.appender.LogFileScavenger;
import uk.org.simonsite.log4j.appender.TimeAndSizeRollingAppender;

abstract class AbstractLogFileScavenger
implements LogFileScavenger,
Runnable {
    private TimeAndSizeRollingAppender appender = null;
    private File file = null;
    private AppenderRollingProperties properties = null;
    private volatile Thread threadRef = null;

    AbstractLogFileScavenger() {
    }

    public final void init(TimeAndSizeRollingAppender appender, AppenderRollingProperties properties) {
        this.appender = appender;
        this.properties = properties;
    }

    public final synchronized void begin() {
        if (this.threadRef == null) {
            this.file = this.getAppender().getIoFile();
            if (this.file == null) {
                this.getAppender().getErrorHandler().error("Scavenger not started: missing log file name");
                return;
            }
            if (this.getProperties().getScavengeInterval() > -1L) {
                Thread thread;
                this.threadRef = thread = new Thread((Runnable)this, "Log4J File Scavenger");
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    public final synchronized void end() {
        Thread thread = this.threadRef;
        this.threadRef = null;
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        LogLog.debug((String)(this.getClass().getName() + " started"));
        try {
            while (this.isRunning()) {
                this.scavenge();
                try {
                    long scavengeInterval = this.getProperties().getScavengeInterval();
                    if (scavengeInterval <= 0L) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    Thread.sleep(scavengeInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Exception e) {
            this.getAppender().getErrorHandler().error("Log file scavenger failed", e, 0);
        }
        LogLog.debug((String)"Log file scavenger stopped");
    }

    public final boolean isRunning() {
        Thread thread = this.threadRef;
        return thread != null ? !thread.isInterrupted() : false;
    }

    final TimeAndSizeRollingAppender getAppender() {
        return this.appender;
    }

    final AppenderRollingProperties getProperties() {
        return this.properties;
    }

    final LogFileList logFileList() {
        final String filename = this.file.getName();
        return new LogFileList(this.file, new FilenameFilter(){

            public final boolean accept(File logDir, String name) {
                return !name.equals(filename) && name.startsWith(filename);
            }
        }, this.getProperties());
    }
}

