/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mm.plugin.logserver;

import com.viettel.mm.plugin.logserver.SocketReader;
import com.viettel.mm.plugin.logserver.TempLogRepository;
import com.viettel.mmserver.base.ProcessThreadMX;
import java.net.Socket;
import java.util.ArrayList;

public class SocketReaderManager
extends ProcessThreadMX {
    public static final int SLEEP_TIME = 100000;
    private ArrayList<SocketReader> socketReaders = new ArrayList();
    private static SocketReaderManager swm;
    public static final int DEFAUTL_MAX_CONNECTION = 100;
    public static final int DEFAULT_MAX_QUEUE = 100;
    private int maxConnection = 100;

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public static synchronized SocketReaderManager getInstance() {
        if (swm == null) {
            swm = new SocketReaderManager();
        }
        return swm;
    }

    private SocketReaderManager() {
        super("SocketReaderManager");
        try {
            super.registerAgent("MM:plugin=log,name=SocketReaderManager");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void process() {
        try {
            Thread.sleep(100000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void stop() {
        try {
            for (SocketReader socketReader : this.socketReaders) {
                socketReader.stop();
            }
            super.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addSocketReader(Socket socket) {
        if (this.socketReaders.size() <= this.maxConnection) {
            SocketReader socketReader = new SocketReader(socket);
            socketReader.setSwm(this);
            socketReader.start();
            this.socketReaders.add(socketReader);
        } else {
            this.logger.error((Object)"Can not add more connection");
        }
    }

    public void removeSocketReader(SocketReader socketReader) {
        if (socketReader != null) {
            this.socketReaders.remove((Object)socketReader);
        }
    }

    public String getInfor() {
        StringBuilder sb = new StringBuilder(super.getInfor());
        sb.append("\n");
        sb.append("Max connections: ");
        sb.append(this.maxConnection);
        sb.append("\nCurrent connections: ");
        sb.append(this.socketReaders.size());
        for (SocketReader socketReader : this.socketReaders) {
            sb.append("\n\t");
            sb.append(socketReader.getInfor());
        }
        sb.append("\nMax queues: ");
        sb.append(TempLogRepository.getInstance().getMaxQueue());
        sb.append("\nCurrent queues: ");
        sb.append(TempLogRepository.getInstance().getCurentQueues());
        sb.append("\nQueue max size: ");
        sb.append(TempLogRepository.getInstance().getQueueMaxSize());
        return sb.toString();
    }
}

