/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mm.plugin.logserver;

import com.viettel.mm.plugin.logserver.LogRepository;
import com.viettel.mm.plugin.logserver.ServerSocketListener;
import com.viettel.mm.plugin.logserver.SocketReaderManager;
import com.viettel.mm.plugin.logserver.TempLogRepository;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class LogServerActivator
implements BundleActivator {
    private ServerSocketListener serverSocketListener = null;
    public static final String CONFIG_PATH_PARAMETER_NAME = "com.viettel.mm.plugin.logserver.configpath";
    public static final String DEFAULT_CONFIG_PATH = "../conf/logserver.cfg";
    private String configPath;
    private Logger logger = Logger.getLogger(this.getClass());

    public void start(BundleContext context) throws Exception {
        if (context.getProperty(CONFIG_PATH_PARAMETER_NAME) == null) {
            this.configPath = DEFAULT_CONFIG_PATH;
            this.logger.info((Object)"Can not get config path from system properties: com.viettel.mm.plugin.logserver.configpath, use default path: ../conf/logserver.cfg");
        } else {
            this.configPath = context.getProperty(CONFIG_PATH_PARAMETER_NAME);
            this.logger.debug((Object)("Load properties file: " + this.configPath));
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(this.configPath));
            int port = Integer.parseInt(properties.getProperty("port"));
            int maxConnection = Integer.parseInt(properties.getProperty("maxConnection"));
            int maxQueue = Integer.parseInt(properties.getProperty("maxQueue"));
            int queueMaxSize = Integer.parseInt(properties.getProperty("queueMaxSize"));
            this.serverSocketListener = new ServerSocketListener(port);
            SocketReaderManager.getInstance().setMaxConnection(maxConnection);
            TempLogRepository.getInstance().setMaxQueue(maxQueue);
            TempLogRepository.getInstance().setQueueMaxSize(queueMaxSize);
            this.serverSocketListener.start();
            context.registerService(LogRepository.class.getName(), (Object)TempLogRepository.getInstance(), null);
        }
        catch (IOException ex) {
            this.logger.error((Object)("Log Server: Cannot read config file: " + this.configPath + ex.getMessage()));
        }
        catch (Exception e) {
            this.logger.error((Object)("Log Server cannot start because of error: " + e.getMessage()));
        }
    }

    public void stop(BundleContext context) throws Exception {
        SocketReaderManager.getInstance().stop();
        this.serverSocketListener.stop();
    }
}

